/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.bukkit.gui;

import java.util.Iterator;
import java.util.UUID;
import java.util.function.Function;
import me.hsgamer.bettergui.lib.core.bukkit.gui.BukkitGUIDisplay;
import me.hsgamer.bettergui.lib.core.bukkit.gui.BukkitGUIHolder;
import me.hsgamer.bettergui.lib.core.bukkit.gui.event.BukkitClickEvent;
import me.hsgamer.bettergui.lib.core.bukkit.gui.event.BukkitDragEvent;
import org.bukkit.Bukkit;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public final class BukkitGUIUtils {
    private BukkitGUIUtils() {
    }

    public static void allowMoveItemOnBottom(BukkitGUIHolder holder) {
        holder.addEventConsumer(BukkitClickEvent.class, event -> {
            InventoryClickEvent clickEvent = (InventoryClickEvent)event.getEvent();
            if (clickEvent.getClickedInventory() == clickEvent.getInventory()) {
                return;
            }
            switch (clickEvent.getAction()) {
                case DROP_ALL_SLOT: 
                case DROP_ONE_SLOT: 
                case PICKUP_ALL: 
                case PICKUP_HALF: 
                case PICKUP_ONE: 
                case PICKUP_SOME: 
                case HOTBAR_MOVE_AND_READD: 
                case PLACE_ALL: 
                case PLACE_ONE: 
                case PLACE_SOME: 
                case HOTBAR_SWAP: 
                case SWAP_WITH_CURSOR: {
                    clickEvent.setCancelled(false);
                    break;
                }
            }
        });
    }

    public static void cancelDragEvent(BukkitGUIHolder holder) {
        holder.addEventConsumer(BukkitDragEvent.class, event -> {
            InventoryDragEvent dragEvent = (InventoryDragEvent)event.getEvent();
            Iterator iterator = dragEvent.getRawSlots().iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                if (slot >= dragEvent.getInventory().getSize()) continue;
                event.setCancelled(true);
                break;
            }
        });
    }

    public static int normalizeToChestSize(int size) {
        int remain = size % 9;
        size -= remain;
        return size += remain > 0 ? 9 : 0;
    }

    public static Function<BukkitGUIDisplay, Inventory> getDefaultInventoryFunction() {
        return display -> {
            BukkitGUIHolder holder = (BukkitGUIHolder)display.getHolder();
            InventoryType type = holder.getInventoryType();
            int size = holder.getSize();
            return type == InventoryType.CHEST && size > 0 ? Bukkit.createInventory((InventoryHolder)display, (int)BukkitGUIUtils.normalizeToChestSize(size)) : Bukkit.createInventory((InventoryHolder)display, (InventoryType)type);
        };
    }

    public static Function<BukkitGUIDisplay, Inventory> getInventoryFunctionFromTitle(Function<UUID, String> titleFunction) {
        return display -> {
            BukkitGUIHolder holder = (BukkitGUIHolder)display.getHolder();
            InventoryType type = holder.getInventoryType();
            int size = holder.getSize();
            String title = (String)titleFunction.apply(display.getUniqueId());
            return type == InventoryType.CHEST && size > 0 ? Bukkit.createInventory((InventoryHolder)display, (int)BukkitGUIUtils.normalizeToChestSize(size), (String)title) : Bukkit.createInventory((InventoryHolder)display, (InventoryType)type, (String)title);
        };
    }
}

