/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.builder;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import me.hsgamer.bettergui.lib.core.builder.MassBuilder;

public class Builder<R, V>
extends MassBuilder<AbstractMap.SimpleEntry<String, R>, V> {
    @Override
    public MassBuilder<AbstractMap.SimpleEntry<String, R>, V> register(Function<AbstractMap.SimpleEntry<String, R>, Optional<V>> element) {
        if (element instanceof FunctionElement) {
            return super.register(element);
        }
        throw new IllegalArgumentException("The element must be a FunctionElement");
    }

    public FunctionElement<R, V> register(BiFunction<String, R, V> biFunction, String ... name) {
        FunctionElement<R, V> element = new FunctionElement<R, V>(biFunction, name);
        this.register(element);
        return element;
    }

    public FunctionElement<R, V> register(Function<R, V> function, String ... name) {
        return this.register((String s, R r) -> function.apply(r), name);
    }

    public FunctionElement<R, V> register(Supplier<V> supplier, String ... name) {
        return this.register((String s, R r) -> supplier.get(), name);
    }

    public Optional<V> build(String name, R rawValue) {
        return this.build(new AbstractMap.SimpleEntry<String, R>(name, rawValue));
    }

    public Map<String, V> build(Map<String, R> rawMap) {
        LinkedHashMap map = new LinkedHashMap();
        rawMap.forEach((name, raw) -> this.build((String)name, (R)raw).ifPresent(v -> map.put(name.toLowerCase(Locale.ROOT), v)));
        return map;
    }

    public Map<String, BiFunction<String, R, V>> getRegisteredMap() {
        HashMap map = new HashMap();
        this.getElements().forEach(element -> {
            if (element instanceof FunctionElement) {
                FunctionElement functionElement = (FunctionElement)element;
                for (String name : functionElement.getNames()) {
                    String lowerCaseName = name.toLowerCase(Locale.ROOT);
                    if (map.containsKey(lowerCaseName)) continue;
                    map.put(lowerCaseName, functionElement.getFunction());
                }
            }
        });
        return map;
    }

    public static class FunctionElement<R, V>
    implements Function<AbstractMap.SimpleEntry<String, R>, Optional<V>> {
        private final BiFunction<String, R, V> function;
        private final String[] names;

        public FunctionElement(BiFunction<String, R, V> function, String ... names) {
            this.function = function;
            this.names = names;
        }

        public BiFunction<String, R, V> getFunction() {
            return this.function;
        }

        public String[] getNames() {
            return this.names;
        }

        @Override
        public Optional<V> apply(AbstractMap.SimpleEntry<String, R> input) {
            String key = input.getKey();
            boolean found = false;
            for (String alias : this.names) {
                if (!key.equalsIgnoreCase(alias)) continue;
                found = true;
                break;
            }
            if (!found) {
                return Optional.empty();
            }
            return Optional.ofNullable(this.function.apply(key, input.getValue()));
        }
    }
}

