/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.animate;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class Animation<T> {
    private final List<T> frames;
    private final long periodMillis;
    private final AtomicLong startMillis = new AtomicLong(-1L);

    public Animation(List<T> frames, long periodMillis) {
        if (frames.isEmpty()) {
            throw new IllegalArgumentException("Frames cannot be empty");
        }
        if (periodMillis <= 0L) {
            throw new IllegalArgumentException("Period must be positive");
        }
        this.frames = frames;
        this.periodMillis = periodMillis;
    }

    public List<T> getFrames() {
        return Collections.unmodifiableList(this.frames);
    }

    public T getCurrentFrame(long currentMillis) {
        long startMillis = this.startMillis.get();
        if (startMillis < 0L) {
            startMillis = currentMillis;
            this.startMillis.set(startMillis);
        }
        long diff = currentMillis - startMillis;
        int index = (int)(diff / this.periodMillis) % this.frames.size();
        return this.frames.get(index);
    }

    public T getCurrentFrame() {
        return this.getCurrentFrame(System.currentTimeMillis());
    }

    public void reset() {
        this.startMillis.set(-1L);
    }

    public boolean isFirstRun(long currentMillis) {
        long startMillis = this.startMillis.get();
        return startMillis < 0L || currentMillis - startMillis < this.periodMillis * (long)this.frames.size();
    }

    public boolean isFirstRun() {
        return this.isFirstRun(System.currentTimeMillis());
    }
}

