/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.action.builder;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface ActionInput {
    public static final Pattern PATTERN = Pattern.compile("\\s*([\\w\\-$]+)\\s*(\\((.*)\\))?\\s*(:\\s*(.*)\\s*)?");

    public static ActionInput create(final String type, final String option, final String value) {
        return new ActionInput(){

            @Override
            public String getType() {
                return type;
            }

            @Override
            public String getOption() {
                return option;
            }

            @Override
            public String getValue() {
                return value;
            }
        };
    }

    public static ActionInput create(String input) {
        Matcher matcher = PATTERN.matcher(input);
        if (matcher.matches()) {
            String type = matcher.group(1);
            String option = Optional.ofNullable(matcher.group(3)).orElse("");
            String value = Optional.ofNullable(matcher.group(5)).orElse("");
            return ActionInput.create(type, option, value);
        }
        return ActionInput.create("", "", input);
    }

    public String getType();

    public String getOption();

    public String getValue();

    default public Stream<String> getOptionStream(String separator) {
        String option = this.getOption();
        return option.isEmpty() ? Stream.empty() : Arrays.stream(option.split(separator)).map(String::trim);
    }

    default public Stream<String> getOptionStream() {
        return this.getOptionStream(",");
    }

    default public List<String> getOptionAsList(String separator) {
        return this.getOptionStream(separator).collect(Collectors.toList());
    }

    default public List<String> getOptionAsList() {
        return this.getOptionStream().collect(Collectors.toList());
    }

    default public Map<String, String> getOptionAsMap(String separator) {
        return this.getOptionStream(separator).map(s -> s.split("=")).collect(Collectors.toMap(strings -> strings[0].trim(), strings -> ((String[])strings).length > 1 ? strings[1].trim() : ""));
    }

    default public Map<String, String> getOptionAsMap() {
        return this.getOptionAsMap(",");
    }
}

