/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.downloader;

import me.hsgamer.bettergui.BetterGUI;
import me.hsgamer.bettergui.lib.core.downloader.core.Downloader;
import me.hsgamer.bettergui.lib.core.downloader.core.object.DownloadInfo;
import me.hsgamer.bettergui.lib.core.downloader.json.JsonDownloadInfoLoader;
import me.hsgamer.bettergui.lib.core.downloader.webstream.WebInputStreamLoader;
import me.hsgamer.bettergui.lib.minelib.plugin.postenable.PostEnable;
import me.hsgamer.bettergui.manager.AddonManager;

public class AddonDownloader
implements PostEnable {
    private final BetterGUI plugin;
    private Downloader downloader;

    public AddonDownloader(BetterGUI plugin) {
        this.plugin = plugin;
    }

    @Override
    public void postEnable() {
        final AddonManager addonManager = this.plugin.get(AddonManager.class);
        this.downloader = new Downloader(new JsonDownloadInfoLoader("https://bettergui-mc.github.io/Addon-List/addons.json"), new WebInputStreamLoader(), addonManager.getExpansionsDir()){

            @Override
            public void onLoaded() {
                for (DownloadInfo downloadInfo : this.getLoadedDownloadInfo().values()) {
                    addonManager.getExpansionClassLoader(downloadInfo.getName()).ifPresent(loader -> {
                        if (!loader.getDescription().getVersion().equals(downloadInfo.getVersion())) {
                            AddonDownloader.this.plugin.getLogger().warning(() -> "The addon '" + downloadInfo.getName() + "' has a new update. New Version: " + downloadInfo.getVersion());
                        }
                    });
                }
            }
        };
        this.downloader.setup();
    }

    public Downloader getDownloader() {
        if (this.downloader == null) {
            throw new IllegalStateException("The downloader is not initialized yet");
        }
        return this.downloader;
    }
}

