/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.config;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import me.hsgamer.bettergui.BetterGUI;
import me.hsgamer.bettergui.builder.ConfigBuilder;
import me.hsgamer.bettergui.config.MainConfig;
import me.hsgamer.bettergui.lib.core.collections.map.CaseInsensitiveStringMap;
import me.hsgamer.bettergui.lib.core.common.MapUtils;
import me.hsgamer.bettergui.lib.minelib.plugin.base.Loadable;
import me.hsgamer.bettergui.lib.minelib.plugin.postenable.PostEnable;

public class TemplateConfig
implements Loadable,
PostEnable {
    private final File templateFolder;
    private final Map<String, Map<String, Object>> templateMap = new HashMap<String, Map<String, Object>>();

    public TemplateConfig(File templateFolder) {
        this.templateFolder = templateFolder;
    }

    public TemplateConfig(BetterGUI plugin) {
        this(new File(plugin.getDataFolder(), "template"));
        if (!this.templateFolder.exists() && this.templateFolder.mkdirs()) {
            plugin.saveResource("template" + File.separator + "example-template.yml", false);
        }
    }

    private static Object replaceVariables(Object obj, Map<String, String> variableMap) {
        if (obj instanceof String) {
            String string = (String)obj;
            for (Map.Entry<String, String> entry : variableMap.entrySet()) {
                string = string.replace("{" + entry.getKey() + "}", entry.getValue());
            }
            return string;
        }
        if (obj instanceof Collection) {
            ArrayList replaceList = new ArrayList();
            ((Collection)obj).forEach(o -> replaceList.add(TemplateConfig.replaceVariables(o, variableMap)));
            return replaceList;
        }
        if (obj instanceof Map) {
            LinkedHashMap replaceMap = new LinkedHashMap();
            ((Map)obj).forEach((k, v) -> replaceMap.put(k, TemplateConfig.replaceVariables(v, variableMap)));
            return replaceMap;
        }
        return obj;
    }

    public void setup() {
        this.setup(this.templateFolder);
    }

    private void setup(File file) {
        if (file.isDirectory()) {
            for (File subFile : Objects.requireNonNull(file.listFiles())) {
                this.setup(subFile);
            }
            return;
        }
        if (file.isFile()) {
            ConfigBuilder.INSTANCE.build(file).ifPresent(config -> {
                config.setup();
                for (Map.Entry<String[], Object> entry : config.getNormalizedValues(false, new String[0]).entrySet()) {
                    String key = entry.getKey()[0];
                    Optional<Map<String, Object>> optionalValues = MapUtils.castOptionalStringObjectMap(entry.getValue());
                    if (!optionalValues.isPresent()) continue;
                    if (BetterGUI.getInstance().get(MainConfig.class).isIncludeMenuInTemplate()) {
                        key = BetterGUI.getInstance().get(MainConfig.class).getFileName(this.templateFolder, file) + "/" + key;
                    }
                    this.templateMap.put(key, optionalValues.get());
                }
            });
        }
    }

    public Map<String, Object> getValues(Map<String, Object> settingMap, List<String> ignoreKeys) {
        LinkedHashMap<String, Object> finalMap = new LinkedHashMap<String, Object>();
        ArrayList<String> ignoreKeyList = new ArrayList<String>(ignoreKeys);
        ignoreKeyList.replaceAll(String::toLowerCase);
        CaseInsensitiveStringMap<Object> keys = new CaseInsensitiveStringMap<Object>(settingMap);
        Optional.ofNullable(keys.get("template")).map(String::valueOf).flatMap(this::get).ifPresent(finalMap::putAll);
        HashMap variableMap = new HashMap();
        Optional.ofNullable(keys.get("variable")).filter(Map.class::isInstance).map(Map.class::cast).ifPresent(map -> map.forEach((k, v) -> {
            String value;
            String variable = String.valueOf(k);
            if (v instanceof List) {
                ArrayList list = new ArrayList();
                ((List)v).forEach(o -> list.add(String.valueOf(o)));
                value = String.join((CharSequence)"\n", list);
            } else {
                value = String.valueOf(v);
            }
            variableMap.put(variable, value);
        }));
        keys.entrySet().stream().filter(entry -> !((String)entry.getKey()).equalsIgnoreCase("variable") && !((String)entry.getKey()).equalsIgnoreCase("template") && !ignoreKeyList.contains(((String)entry.getKey()).toLowerCase())).forEach(entry -> finalMap.put((String)entry.getKey(), entry.getValue()));
        if (!variableMap.isEmpty()) {
            finalMap.replaceAll((s, o) -> TemplateConfig.replaceVariables(o, variableMap));
        }
        return finalMap;
    }

    public Map<String, Object> getValues(Map<String, Object> settingMap, String ... ignoreKeys) {
        return this.getValues(settingMap, Arrays.asList(ignoreKeys));
    }

    public void clear() {
        this.templateMap.clear();
    }

    public Optional<Map<String, Object>> get(String name) {
        return Optional.ofNullable(this.templateMap.get(name));
    }

    public Collection<String> getAllTemplateNames() {
        return this.templateMap.keySet();
    }

    @Override
    public void postEnable() {
        this.setup();
    }

    @Override
    public void disable() {
        this.clear();
    }
}

