/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.config;

import java.io.File;
import java.net.URI;
import me.hsgamer.bettergui.lib.core.config.annotation.ConfigPath;

public interface MainConfig {
    @ConfigPath(value={"use-modern-click-type"})
    default public boolean isModernClickType() {
        return false;
    }

    @ConfigPath(value={"use-legacy-button"})
    default public boolean isUseLegacyButton() {
        return true;
    }

    @ConfigPath(value={"relative-menu-name"})
    default public boolean isRelativeMenuName() {
        return false;
    }

    @ConfigPath(value={"trim-menu-file-extension"})
    default public boolean isTrimMenuFileExtension() {
        return false;
    }

    @ConfigPath(value={"include-menu-in-template"})
    default public boolean isIncludeMenuInTemplate() {
        return false;
    }

    public void reloadConfig();

    default public String getFileName(File rootFolder, File file) {
        int index;
        String name;
        if (this.isRelativeMenuName()) {
            URI menusFolderURI = rootFolder.toURI();
            URI fileURI = file.toURI();
            name = menusFolderURI.relativize(fileURI).getPath();
        } else {
            name = file.getName();
        }
        if (this.isTrimMenuFileExtension() && (index = name.lastIndexOf(46)) > 0) {
            name = name.substring(0, index);
        }
        return name;
    }
}

