/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.button;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListSet;
import me.hsgamer.bettergui.BetterGUI;
import me.hsgamer.bettergui.api.button.BaseWrappedButton;
import me.hsgamer.bettergui.api.button.WrappedButton;
import me.hsgamer.bettergui.api.requirement.Requirement;
import me.hsgamer.bettergui.builder.ButtonBuilder;
import me.hsgamer.bettergui.config.MainConfig;
import me.hsgamer.bettergui.lib.core.bukkit.clicktype.BukkitClickType;
import me.hsgamer.bettergui.lib.core.bukkit.clicktype.ClickTypeUtils;
import me.hsgamer.bettergui.lib.core.bukkit.gui.event.BukkitClickEvent;
import me.hsgamer.bettergui.lib.core.collections.map.CaseInsensitiveStringMap;
import me.hsgamer.bettergui.lib.core.common.MapUtils;
import me.hsgamer.bettergui.lib.core.minecraft.gui.button.Button;
import me.hsgamer.bettergui.lib.core.minecraft.gui.button.impl.PredicateButton;
import me.hsgamer.bettergui.lib.core.task.BatchRunnable;
import me.hsgamer.bettergui.requirement.RequirementApplier;
import me.hsgamer.bettergui.util.SchedulerUtil;
import org.bukkit.event.inventory.InventoryClickEvent;

public class WrappedPredicateButton
extends BaseWrappedButton<PredicateButton> {
    private final Set<UUID> checked = new ConcurrentSkipListSet<UUID>();

    public WrappedPredicateButton(ButtonBuilder.Input input) {
        super(input);
    }

    public static void applyRequirement(Map<String, Object> section, WrappedButton wrappedButton, Set<UUID> checked, PredicateButton predicateButton) {
        boolean checkOnlyOnCreation = Optional.ofNullable(section.get("check-only-on-creation")).map(String::valueOf).map(Boolean::parseBoolean).orElse(false);
        boolean preventSpamClick = Optional.ofNullable(section.get("prevent-spam-click")).map(String::valueOf).map(Boolean::parseBoolean).orElse(true);
        predicateButton.setPreventSpamClick(preventSpamClick);
        Optional.ofNullable(section.get("view-requirement")).flatMap(MapUtils::castOptionalStringObjectMap).ifPresent(subsection -> {
            RequirementApplier requirementApplier = new RequirementApplier(wrappedButton.getMenu(), wrappedButton.getName() + "_view", (Map<String, Object>)subsection);
            predicateButton.setViewPredicate(uuid -> {
                if (checkOnlyOnCreation && checked.contains(uuid)) {
                    return true;
                }
                Requirement.Result result = requirementApplier.getResult((UUID)uuid);
                if (result.isSuccess) {
                    checked.add((UUID)uuid);
                }
                BatchRunnable batchRunnable = new BatchRunnable();
                batchRunnable.getTaskPool(9).addLast(process -> {
                    result.applier.accept(uuid, process);
                    process.next();
                });
                SchedulerUtil.async().run(batchRunnable);
                return result.isSuccess;
            });
        });
        Optional.ofNullable(section.get("click-requirement")).flatMap(MapUtils::castOptionalStringObjectMap).ifPresent(subsection -> {
            Map<BukkitClickType, RequirementApplier> clickRequirements = RequirementApplier.convertClickRequirementAppliers(subsection, wrappedButton);
            predicateButton.setClickFuturePredicate(clickEvent -> {
                if (!(clickEvent instanceof BukkitClickEvent)) {
                    return CompletableFuture.completedFuture(false);
                }
                BukkitClickEvent bukkitClickEvent = (BukkitClickEvent)clickEvent;
                RequirementApplier clickRequirement = (RequirementApplier)clickRequirements.get(ClickTypeUtils.getClickTypeFromEvent((InventoryClickEvent)bukkitClickEvent.getEvent(), BetterGUI.getInstance().get(MainConfig.class).isModernClickType()));
                return CompletableFuture.supplyAsync(() -> clickRequirement.getResult(clickEvent.getViewerID())).thenApply(result -> {
                    BatchRunnable batchRunnable = new BatchRunnable();
                    batchRunnable.getTaskPool(9).addLast(process -> {
                        result.applier.accept(clickEvent.getViewerID(), process);
                        process.next();
                    });
                    SchedulerUtil.async().run(batchRunnable);
                    return result.isSuccess;
                });
            });
        });
    }

    @Override
    protected PredicateButton createButton(Map<String, Object> section) {
        CaseInsensitiveStringMap<Object> keys = new CaseInsensitiveStringMap<Object>(section);
        PredicateButton predicateButton = new PredicateButton();
        Optional.ofNullable(keys.get("button")).flatMap(MapUtils::castOptionalStringObjectMap).flatMap(subsection -> ButtonBuilder.INSTANCE.build(new ButtonBuilder.Input(this.getMenu(), this.getName() + "_button", (Map<String, Object>)subsection))).ifPresent(predicateButton::setButton);
        Optional.ofNullable(keys.get("fallback")).flatMap(MapUtils::castOptionalStringObjectMap).flatMap(subsection -> ButtonBuilder.INSTANCE.build(new ButtonBuilder.Input(this.getMenu(), this.getName() + "_fallback", (Map<String, Object>)subsection))).ifPresent(predicateButton::setFallbackButton);
        WrappedPredicateButton.applyRequirement(keys, this, this.checked, predicateButton);
        return predicateButton;
    }

    @Override
    public void refresh(UUID uuid) {
        this.checked.remove(uuid);
        if (this.button == null) {
            return;
        }
        Button tempButton = ((PredicateButton)this.button).getButton();
        if (tempButton instanceof WrappedButton) {
            ((WrappedButton)tempButton).refresh(uuid);
        }
        if ((tempButton = ((PredicateButton)this.button).getFallbackButton()) instanceof WrappedButton) {
            ((WrappedButton)tempButton).refresh(uuid);
        }
    }
}

