/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.builder;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.hsgamer.bettergui.lib.core.builder.FunctionalMassBuilder;
import me.hsgamer.bettergui.lib.core.bukkit.item.modifier.AmountModifier;
import me.hsgamer.bettergui.lib.core.bukkit.item.modifier.DurabilityModifier;
import me.hsgamer.bettergui.lib.core.bukkit.item.modifier.EnchantmentModifier;
import me.hsgamer.bettergui.lib.core.bukkit.item.modifier.ItemFlagModifier;
import me.hsgamer.bettergui.lib.core.bukkit.item.modifier.LoreModifier;
import me.hsgamer.bettergui.lib.core.bukkit.item.modifier.MaterialModifier;
import me.hsgamer.bettergui.lib.core.bukkit.item.modifier.NameModifier;
import me.hsgamer.bettergui.lib.core.bukkit.item.modifier.PotionEffectModifier;
import me.hsgamer.bettergui.lib.core.minecraft.item.ItemModifier;
import me.hsgamer.bettergui.modifier.NBTModifier;
import me.hsgamer.bettergui.modifier.SkullModifier;
import org.bukkit.inventory.ItemStack;

public class ItemModifierBuilder
extends FunctionalMassBuilder<Map.Entry<String, Object>, ItemModifier<ItemStack>> {
    public static final ItemModifierBuilder INSTANCE = new ItemModifierBuilder();

    private ItemModifierBuilder() {
        this.register(NameModifier::new, "name");
        this.register(LoreModifier::new, "lore");
        this.register(AmountModifier::new, "amount");
        this.register(DurabilityModifier::new, "durability", "damage");
        this.register(MaterialModifier::new, "material", "id", "mat", "raw-material", "raw-id", "raw-mat");
        this.register(EnchantmentModifier::new, "enchantment", "enchant", "enc");
        this.register(ItemFlagModifier::new, "flag", "item-flags", "itemflag", "itemflags", "item-flag");
        this.register(SkullModifier::new, "skull", "head", "skull-owner");
        this.register(NBTModifier::new, "nbt", "nbt-data");
        this.register(PotionEffectModifier::new, "potion-effect", "potion", "effect");
    }

    @Override
    protected String getType(Map.Entry<String, Object> input) {
        return input.getKey();
    }

    public void register(Supplier<ItemModifier<ItemStack>> creator, String ... type) {
        this.register((I input) -> {
            ItemModifier itemModifier = (ItemModifier)creator.get();
            Object value = input.getValue();
            itemModifier.loadFromObject(value);
            return itemModifier;
        }, type);
    }

    @Override
    public List<ItemModifier<ItemStack>> build(Map<String, Object> map) {
        return map.entrySet().stream().flatMap(entry -> this.build(entry).map(Stream::of).orElse(Stream.empty())).collect(Collectors.toList());
    }
}

