/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.builder;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.hsgamer.bettergui.BetterGUI;
import me.hsgamer.bettergui.api.button.WrappedButton;
import me.hsgamer.bettergui.api.menu.Menu;
import me.hsgamer.bettergui.button.EmptyButton;
import me.hsgamer.bettergui.button.LegacyMenuButton;
import me.hsgamer.bettergui.button.TemplateButton;
import me.hsgamer.bettergui.button.WrappedAirButton;
import me.hsgamer.bettergui.button.WrappedAnimatedButton;
import me.hsgamer.bettergui.button.WrappedDummyButton;
import me.hsgamer.bettergui.button.WrappedListButton;
import me.hsgamer.bettergui.button.WrappedNullButton;
import me.hsgamer.bettergui.button.WrappedPredicateButton;
import me.hsgamer.bettergui.button.WrappedSimpleButton;
import me.hsgamer.bettergui.config.MainConfig;
import me.hsgamer.bettergui.lib.core.builder.FunctionalMassBuilder;
import me.hsgamer.bettergui.lib.core.collections.map.CaseInsensitiveStringMap;

public final class ButtonBuilder
extends FunctionalMassBuilder<Input, WrappedButton> {
    public static final ButtonBuilder INSTANCE = new ButtonBuilder();

    private ButtonBuilder() {
        this.register(TemplateButton::new, "template");
        this.register(WrappedDummyButton::new, "dummy", "raw");
        this.register(EmptyButton::new, "empty");
        this.register(WrappedAirButton::new, "air");
        this.register(WrappedPredicateButton::new, "predicate", "requirement");
        this.register(WrappedListButton::new, "list");
        this.register(WrappedAnimatedButton::new, "animated", "animate", "anim");
        this.register(WrappedNullButton::new, "null", "none");
        this.register((I input) -> BetterGUI.getInstance().get(MainConfig.class).isUseLegacyButton() ? new LegacyMenuButton((Input)input) : new WrappedSimpleButton((Input)input), "simple");
    }

    @Override
    protected String getType(Input input) {
        return Objects.toString(new CaseInsensitiveStringMap<Object>(input.options).get("type"), "simple");
    }

    public List<WrappedButton> getChildButtons(WrappedButton parentButton, Map<String, Object> section) {
        return section.entrySet().stream().filter(entry -> entry.getValue() instanceof Map).map(entry -> {
            Map value = (Map)entry.getValue();
            String name = parentButton.getName() + "_child_" + (String)entry.getKey();
            return new Input(parentButton.getMenu(), name, value);
        }).flatMap(input -> this.build(input).map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toList());
    }

    public static class Input {
        public final Menu menu;
        public final String name;
        public final Map<String, Object> options;

        public Input(Menu menu, String name, Map<String, Object> options) {
            this.menu = menu;
            this.name = name;
            this.options = options;
        }
    }
}

