/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.builder;

import java.util.Map;
import java.util.Objects;
import me.hsgamer.bettergui.api.argument.ArgumentProcessor;
import me.hsgamer.bettergui.api.menu.Menu;
import me.hsgamer.bettergui.argument.type.DecimalArgumentProcessor;
import me.hsgamer.bettergui.argument.type.EntityTypeArgumentProcessor;
import me.hsgamer.bettergui.argument.type.MaterialArgumentProcessor;
import me.hsgamer.bettergui.argument.type.NumberArgumentProcessor;
import me.hsgamer.bettergui.argument.type.PlayerArgumentProcessor;
import me.hsgamer.bettergui.argument.type.StoreArgumentProcessor;
import me.hsgamer.bettergui.lib.core.builder.FunctionalMassBuilder;
import me.hsgamer.bettergui.lib.core.collections.map.CaseInsensitiveStringMap;

public final class ArgumentProcessorBuilder
extends FunctionalMassBuilder<Input, ArgumentProcessor> {
    public static final ArgumentProcessorBuilder INSTANCE = new ArgumentProcessorBuilder();

    private ArgumentProcessorBuilder() {
        this.register(StoreArgumentProcessor::new, "store");
        this.register(PlayerArgumentProcessor::new, "player");
        this.register(NumberArgumentProcessor::new, "number", "int", "integer", "long");
        this.register(DecimalArgumentProcessor::new, "decimal", "float", "double");
        this.register(EntityTypeArgumentProcessor::new, "entity");
        this.register(MaterialArgumentProcessor::new, "material", "item");
    }

    @Override
    protected String getType(Input input) {
        return Objects.toString(new CaseInsensitiveStringMap<Object>(input.options).get("type"), "store");
    }

    public static class Input {
        public final Menu menu;
        public final String name;
        public final Map<String, Object> options;

        public Input(Menu menu, String name, Map<String, Object> options) {
            this.menu = menu;
            this.name = name;
            this.options = options;
        }
    }
}

