/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.argument.type;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import me.hsgamer.bettergui.argument.type.BaseActionArgumentProcessor;
import me.hsgamer.bettergui.builder.ArgumentProcessorBuilder;
import me.hsgamer.bettergui.lib.core.common.CollectionUtils;
import me.hsgamer.bettergui.lib.core.common.MapUtils;
import me.hsgamer.bettergui.lib.core.common.Pair;
import me.hsgamer.bettergui.lib.core.common.Validate;
import me.hsgamer.bettergui.lib.core.task.BatchRunnable;
import me.hsgamer.bettergui.lib.core.task.element.TaskProcess;
import me.hsgamer.bettergui.util.SchedulerUtil;

public class StoreArgumentProcessor
extends BaseActionArgumentProcessor {
    private final Map<UUID, String> map = new HashMap<UUID, String>();
    private final int length = Optional.ofNullable(MapUtils.getIfFound(this.options, "length", "size")).map(String::valueOf).flatMap(Validate::getNumber).map(BigDecimal::intValue).orElse(1);
    private final boolean takeRemaining = Optional.ofNullable(MapUtils.getIfFound(this.options, "take-remaining", "take-remain", "remaining", "remain")).map(String::valueOf).map(Boolean::parseBoolean).orElse(false);
    private final List<String> suggestions = Optional.ofNullable(MapUtils.getIfFound(this.options, "suggestion", "suggest")).map(CollectionUtils::createStringListFromObject).orElse(Collections.emptyList());
    private final boolean checkSuggestion = Optional.ofNullable(MapUtils.getIfFound(this.options, "check-suggestion", "check-suggest")).map(String::valueOf).map(Boolean::parseBoolean).orElse(false);

    public StoreArgumentProcessor(ArgumentProcessorBuilder.Input input) {
        super(input);
    }

    @Override
    public Optional<String[]> process(UUID uuid, String[] args) {
        String[] remaining;
        String current;
        if (!this.takeRemaining && this.length <= 0) {
            return Optional.empty();
        }
        if (this.length > 0 && args.length < this.length) {
            BatchRunnable batchRunnable = new BatchRunnable();
            batchRunnable.getTaskPool(99).addLast(process -> this.onRequiredActionApplier.accept(uuid, (TaskProcess)process));
            SchedulerUtil.async().run(batchRunnable);
            return Optional.empty();
        }
        if (this.takeRemaining) {
            current = String.join((CharSequence)" ", args);
            remaining = new String[]{};
        } else {
            CharSequence[] store = Arrays.copyOfRange(args, 0, this.length);
            current = String.join((CharSequence)" ", store);
            remaining = Arrays.copyOfRange(args, this.length, args.length);
        }
        if (this.checkSuggestion && !this.suggestions.isEmpty() && !this.suggestions.contains(current)) {
            BatchRunnable batchRunnable = new BatchRunnable();
            batchRunnable.getTaskPool(99).addLast(process -> this.onInvalidActionApplier.accept(uuid, (TaskProcess)process));
            SchedulerUtil.async().run(batchRunnable);
            return Optional.empty();
        }
        this.map.put(uuid, current);
        return Optional.of(remaining);
    }

    @Override
    public String getValue(String query, UUID uuid) {
        return this.map.getOrDefault(uuid, "");
    }

    @Override
    public Pair<Optional<List<String>>, String[]> tabComplete(UUID uuid, String[] args) {
        if (!this.takeRemaining) {
            if (this.length <= 0) {
                return Pair.of(Optional.empty(), args);
            }
            if (args.length > this.length) {
                return Pair.of(Optional.empty(), Arrays.copyOfRange(args, this.length, args.length));
            }
        }
        String current = String.join((CharSequence)" ", args);
        List list = this.suggestions.stream().filter(string -> string.length() > current.length()).filter(string -> string.toLowerCase(Locale.ROOT).startsWith(current.toLowerCase(Locale.ROOT))).map(string -> {
            String[] split = string.split(" ");
            return split[args.length - 1];
        }).collect(Collectors.toList());
        return Pair.of(Optional.of(list), new String[0]);
    }
}

