/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.api.requirement;

import java.util.UUID;
import java.util.function.Consumer;
import me.hsgamer.bettergui.api.menu.MenuElement;
import me.hsgamer.bettergui.api.process.ProcessApplier;

public interface Requirement
extends MenuElement {
    public Result check(UUID var1);

    public String getName();

    public static class Result {
        public final boolean isSuccess;
        public final ProcessApplier applier;

        public Result(boolean success, ProcessApplier applier) {
            this.isSuccess = success;
            this.applier = applier;
        }

        public static Result success(ProcessApplier applier) {
            return new Result(true, applier);
        }

        public static Result success(Consumer<UUID> applier) {
            return new Result(true, (uuid, process) -> {
                applier.accept((UUID)uuid);
                process.next();
            });
        }

        public static Result success() {
            return new Result(true, (uuid, process) -> process.next());
        }

        public static Result fail(ProcessApplier applier) {
            return new Result(false, applier);
        }

        public static Result fail(Consumer<UUID> applier) {
            return new Result(false, (uuid, process) -> {
                applier.accept((UUID)uuid);
                process.next();
            });
        }

        public static Result fail() {
            return new Result(false, (uuid, process) -> process.next());
        }
    }
}

