/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.api.requirement;

import java.util.UUID;
import me.hsgamer.bettergui.api.menu.Menu;
import me.hsgamer.bettergui.api.requirement.Requirement;
import me.hsgamer.bettergui.builder.RequirementBuilder;

public abstract class BaseRequirement<V>
implements Requirement {
    private final String name;
    private final Object value;
    private final Menu menu;

    protected BaseRequirement(RequirementBuilder.Input input) {
        this.name = input.name;
        this.menu = input.menu;
        this.value = this.handleValue(input.value);
    }

    protected Object handleValue(Object inputValue) {
        return inputValue;
    }

    protected abstract V convert(Object var1, UUID var2);

    protected abstract Requirement.Result checkConverted(UUID var1, V var2);

    public final V getFinalValue(UUID uuid) {
        return this.convert(this.value, uuid);
    }

    @Override
    public Requirement.Result check(UUID uuid) {
        return this.checkConverted(uuid, this.getFinalValue(uuid));
    }

    @Override
    public Menu getMenu() {
        return this.menu;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

