/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.api.menu;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import me.hsgamer.bettergui.lib.core.common.StringReplacer;
import me.hsgamer.bettergui.lib.core.config.Config;
import me.hsgamer.bettergui.lib.core.variable.VariableManager;
import org.bukkit.entity.Player;

public abstract class Menu {
    public static final String MENU_SETTINGS_PATH = "menu-settings";
    protected final Config config;
    protected final VariableManager variableManager = new VariableManager();
    private final Map<UUID, Menu> parentMenu = new HashMap<UUID, Menu>();

    protected Menu(Config config) {
        this.config = config;
        this.variableManager.register("current-menu", original -> this.getName(), true);
        this.variableManager.register("parent-menu", StringReplacer.of((original, uuid) -> this.getParentMenu((UUID)uuid).map(Menu::getName).orElse("")));
        this.variableManager.addExternalReplacer(VariableManager.GLOBAL);
    }

    public String getName() {
        return this.config.getName();
    }

    public Config getConfig() {
        return this.config;
    }

    public VariableManager getVariableManager() {
        return this.variableManager;
    }

    public abstract boolean create(Player var1, String[] var2, boolean var3);

    public List<String> tabComplete(Player player, String[] args) {
        return Collections.emptyList();
    }

    public abstract void update(Player var1);

    public abstract void close(Player var1);

    public abstract void closeAll();

    public Optional<Menu> getParentMenu(UUID uuid) {
        return Optional.ofNullable(this.parentMenu.get(uuid));
    }

    public void setParentMenu(UUID uuid, Menu menu) {
        if (menu == null) {
            this.parentMenu.remove(uuid);
        } else {
            this.parentMenu.put(uuid, menu);
        }
    }
}

