/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.action.type;

import java.util.UUID;
import me.hsgamer.bettergui.lib.core.action.common.Action;
import me.hsgamer.bettergui.lib.core.common.StringReplacer;
import me.hsgamer.bettergui.lib.core.task.element.TaskProcess;
import me.hsgamer.bettergui.util.SchedulerUtil;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class SoundAction
implements Action {
    private final String value;

    public SoundAction(String value) {
        this.value = value;
    }

    @Override
    public void apply(UUID uuid, TaskProcess process, StringReplacer stringReplacer) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            process.next();
            return;
        }
        float volume = 1.0f;
        float pitch = 1.0f;
        String replaced = stringReplacer.replaceOrOriginal(this.value, uuid);
        String[] split = replaced.indexOf(44) != -1 ? replaced.split(",") : replaced.split(" ");
        String sound = split[0].trim();
        if (split.length > 1) {
            try {
                volume = Float.parseFloat(split[1].trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (split.length > 2) {
            try {
                pitch = Float.parseFloat(split[2].trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        float finalVolume = volume;
        float finalPitch = pitch;
        SchedulerUtil.entity((Entity)player).run(() -> {
            try {
                Sound soundEnum = Sound.valueOf((String)sound.replace(" ", "_").toUpperCase());
                player.playSound(player.getLocation(), soundEnum, finalVolume, finalPitch);
            }
            catch (Exception exception) {
                player.playSound(player.getLocation(), sound, finalVolume, finalPitch);
            }
            finally {
                process.next();
            }
        }, process::next);
    }
}

