/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.action;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import me.hsgamer.bettergui.action.ActionApplier;
import me.hsgamer.bettergui.api.menu.Menu;
import me.hsgamer.bettergui.lib.core.bukkit.clicktype.BukkitClickType;
import me.hsgamer.bettergui.lib.core.bukkit.clicktype.ClickTypeUtils;
import me.hsgamer.bettergui.lib.core.collections.map.CaseInsensitiveStringMap;
import me.hsgamer.bettergui.lib.core.task.BatchRunnable;
import me.hsgamer.bettergui.lib.core.task.element.TaskProcess;
import me.hsgamer.bettergui.util.SchedulerUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class ClickActionHandler {
    private final Menu menu;
    private final Map<BukkitClickType, ActionApplier> actionMap;
    private final boolean closeOnClick;

    public ClickActionHandler(Menu menu, Map<BukkitClickType, ActionApplier> actionMap, boolean closeOnClick) {
        this.menu = menu;
        this.actionMap = actionMap;
        this.closeOnClick = closeOnClick;
    }

    public ClickActionHandler(Menu menu, Object o, boolean closeOnClick) {
        this(menu, new HashMap<BukkitClickType, ActionApplier>(), closeOnClick);
        Map<String, BukkitClickType> clickTypeMap = ClickTypeUtils.getClickTypeMap();
        if (o instanceof Map) {
            CaseInsensitiveStringMap keys = new CaseInsensitiveStringMap((Map)o);
            Optional<ActionApplier> defaultActionApplier = Optional.ofNullable(keys.get("default")).map(value -> new ActionApplier(menu, value));
            clickTypeMap.forEach((clickTypeName, clickType) -> {
                if (keys.containsKey(clickTypeName)) {
                    this.actionMap.put((BukkitClickType)clickType, new ActionApplier(menu, keys.get(clickTypeName)));
                } else {
                    defaultActionApplier.ifPresent(actionApplier -> this.actionMap.put((BukkitClickType)clickType, (ActionApplier)actionApplier));
                }
            });
        } else {
            clickTypeMap.values().forEach(advancedClickType -> this.actionMap.put((BukkitClickType)advancedClickType, new ActionApplier(menu, o)));
        }
    }

    public void apply(UUID uuid, BukkitClickType clickType, BatchRunnable batchRunnable) {
        Optional.ofNullable(this.actionMap.get(clickType)).ifPresent(actionApplier -> batchRunnable.getTaskPool(99).addLast(process -> actionApplier.accept(uuid, (TaskProcess)process)));
        if (this.closeOnClick) {
            Optional.ofNullable(Bukkit.getPlayer((UUID)uuid)).ifPresent(player -> batchRunnable.getTaskPool(99).addLast(process -> SchedulerUtil.entity((Entity)player).run(() -> {
                try {
                    this.menu.close((Player)player);
                }
                finally {
                    process.next();
                }
            }, process::next)));
        }
    }
}

