/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.action;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import me.hsgamer.bettergui.api.menu.Menu;
import me.hsgamer.bettergui.api.process.ProcessApplier;
import me.hsgamer.bettergui.builder.ActionBuilder;
import me.hsgamer.bettergui.lib.core.action.common.Action;
import me.hsgamer.bettergui.lib.core.common.StringReplacer;
import me.hsgamer.bettergui.lib.core.task.element.TaskPool;
import me.hsgamer.bettergui.lib.core.task.element.TaskProcess;
import me.hsgamer.bettergui.util.StringReplacerApplier;

public class ActionApplier
implements ProcessApplier {
    public static final ActionApplier EMPTY = new ActionApplier(Collections.emptyList(), StringReplacer.DUMMY);
    private final List<Action> actions;
    private final StringReplacer replacer;

    public ActionApplier(List<Action> actions, StringReplacer replacer) {
        this.actions = actions;
        this.replacer = replacer;
    }

    public ActionApplier(Menu menu, Object value) {
        this(ActionBuilder.INSTANCE.build(menu, value), StringReplacer.of((original, uuid) -> StringReplacerApplier.replace(original, uuid, menu)));
    }

    public boolean isEmpty() {
        return this.actions.isEmpty();
    }

    public void acceptWithoutNext(UUID uuid, TaskProcess process) {
        TaskPool currentPool = process.getCurrentTaskPool();
        for (Action action : this.actions) {
            currentPool.addLast(subProcess -> action.apply(uuid, (TaskProcess)subProcess, this.replacer));
        }
    }

    @Override
    public void accept(UUID uuid, TaskProcess process) {
        this.acceptWithoutNext(uuid, process);
        process.next();
    }
}

