/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.util;

import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import me.hsgamer.bettergui.lib.core.common.Validate;
import me.hsgamer.bettergui.lib.core.minecraft.gui.GUIProperties;

public class TickUtil {
    public static long ticksToMillis(long ticks) {
        return ticks * GUIProperties.getMillisPerTick();
    }

    public static long fpsToMillis(double fps) {
        return (long)(1000.0 / fps);
    }

    public static Optional<Long> toMillis(String input) {
        Function<Number, Long> function;
        String number;
        String lowerCase = input.toLowerCase(Locale.ROOT);
        if (lowerCase.endsWith("t")) {
            number = input.substring(0, input.length() - 1);
            function = n -> TickUtil.ticksToMillis(n.longValue());
        } else if (lowerCase.endsWith("ms")) {
            number = input.substring(0, input.length() - 2);
            function = Number::longValue;
        } else if (lowerCase.endsWith("fps")) {
            number = input.substring(0, input.length() - 3);
            function = n -> TickUtil.fpsToMillis(n.doubleValue());
        } else {
            number = input;
            function = n -> TickUtil.ticksToMillis(n.longValue());
        }
        return Validate.getNumber(number.trim()).map(function);
    }
}

