/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.util;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.hsgamer.bettergui.api.menu.Menu;
import me.hsgamer.bettergui.api.menu.MenuElement;
import me.hsgamer.bettergui.lib.core.bukkit.utils.ColorUtils;
import me.hsgamer.bettergui.lib.core.common.StringReplacer;
import me.hsgamer.bettergui.lib.core.minecraft.item.ItemBuilder;
import me.hsgamer.bettergui.lib.core.variable.VariableManager;

public final class StringReplacerApplier {
    public static final StringReplacer COLORIZE = ColorUtils::colorize;
    private static final List<StringReplacer> STRING_REPLACERS = new ArrayList<StringReplacer>();

    private StringReplacerApplier() {
    }

    public static List<StringReplacer> getStringReplacers() {
        return STRING_REPLACERS;
    }

    public static <T> ItemBuilder<T> apply(ItemBuilder<T> itemBuilder, boolean useGlobalVariableManager) {
        if (useGlobalVariableManager) {
            itemBuilder.addStringReplacer(VariableManager.GLOBAL);
        }
        STRING_REPLACERS.forEach(itemBuilder::addStringReplacer);
        return itemBuilder;
    }

    public static <T> ItemBuilder<T> apply(ItemBuilder<T> itemBuilder, Menu menu) {
        return StringReplacerApplier.apply(itemBuilder.addStringReplacer(menu.getVariableManager()), false);
    }

    public static <T> ItemBuilder<T> apply(ItemBuilder<T> itemBuilder, MenuElement menuElement) {
        return StringReplacerApplier.apply(itemBuilder, menuElement.getMenu());
    }

    public static String replace(String string, UUID uuid, boolean useGlobalVariableManager) {
        String replaced = string;
        if (useGlobalVariableManager) {
            replaced = VariableManager.GLOBAL.setVariables(replaced, uuid);
        }
        for (StringReplacer replacer : STRING_REPLACERS) {
            String newString = replacer.tryReplace(replaced, uuid);
            if (newString == null) continue;
            replaced = newString;
        }
        return replaced;
    }

    public static String replace(String string, UUID uuid, Menu menu) {
        String replaced = menu.getVariableManager().tryReplace(string, uuid);
        if (replaced == null) {
            return string;
        }
        return StringReplacerApplier.replace(replaced, uuid, false);
    }

    public static String replace(String string, UUID uuid, MenuElement menuElement) {
        return StringReplacerApplier.replace(string, uuid, menuElement.getMenu());
    }

    public static String normalizeQuery(String query) {
        if (query.startsWith("papi_")) {
            return "%" + query.substring("papi_".length()) + "%";
        }
        return "{" + query + "}";
    }

    static {
        STRING_REPLACERS.add(COLORIZE);
    }
}

