/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.util;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import me.hsgamer.bettergui.lib.core.common.Validate;

public class SlotUtil {
    private static final String POS_X = "position-x";
    private static final String POS_Y = "position-y";
    private static final String POS_SLOT = "slot";

    private SlotUtil() {
    }

    public static IntStream getSlots(Map<String, Object> map) {
        IntStream slots = IntStream.empty();
        if (map.containsKey(POS_X) || map.containsKey(POS_Y)) {
            Optional<Integer> x = Validate.getNumber(String.valueOf(map.get(POS_X))).map(BigDecimal::intValue);
            Optional<Integer> y = Validate.getNumber(String.valueOf(map.get(POS_Y))).map(BigDecimal::intValue);
            if (x.isPresent() && y.isPresent()) {
                slots = IntStream.of((y.get() - 1) * 9 + x.get() - 1);
            }
        }
        if (map.containsKey(POS_SLOT)) {
            slots = IntStream.concat(slots, SlotUtil.generateSlots(String.valueOf(map.get(POS_SLOT))));
        }
        return slots;
    }

    public static IntStream generateSlots(String input) {
        return Arrays.stream(input.split(",")).map(String::trim).flatMapToInt(rawSlot -> {
            String[] rangeSplit = rawSlot.split("-", 2);
            if (rangeSplit.length == 2) {
                Optional<Integer> start = Validate.getNumber(rangeSplit[0]).map(BigDecimal::intValue);
                Optional<Integer> end = Validate.getNumber(rangeSplit[1]).map(BigDecimal::intValue);
                if (start.isPresent() && end.isPresent()) {
                    return IntStream.rangeClosed(start.get(), end.get());
                }
                return IntStream.empty();
            }
            return Validate.getNumber(rawSlot).map(BigDecimal::intValue).map(IntStream::of).orElseGet(IntStream::empty);
        });
    }
}

