/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.requirement.type;

import java.util.List;
import java.util.UUID;
import me.hsgamer.bettergui.api.requirement.BaseRequirement;
import me.hsgamer.bettergui.api.requirement.Requirement;
import me.hsgamer.bettergui.builder.RequirementBuilder;
import me.hsgamer.bettergui.lib.core.bukkit.utils.PermissionUtils;
import me.hsgamer.bettergui.lib.core.common.CollectionUtils;
import me.hsgamer.bettergui.util.StringReplacerApplier;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PermissionRequirement
extends BaseRequirement<List<String>> {
    public PermissionRequirement(RequirementBuilder.Input input) {
        super(input);
    }

    @Override
    protected List<String> convert(Object value, UUID uuid) {
        List<String> list = CollectionUtils.createStringListFromObject(value, true);
        list.replaceAll(s -> StringReplacerApplier.replace(s, uuid, this));
        return list;
    }

    @Override
    protected Requirement.Result checkConverted(UUID uuid, List<String> value) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return Requirement.Result.success();
        }
        if (value.stream().allMatch(s -> PermissionUtils.hasPermission(player, s))) {
            return Requirement.Result.success();
        }
        return Requirement.Result.fail();
    }
}

