/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.requirement.type;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.hsgamer.bettergui.BetterGUI;
import me.hsgamer.bettergui.api.requirement.BaseRequirement;
import me.hsgamer.bettergui.api.requirement.Requirement;
import me.hsgamer.bettergui.builder.RequirementBuilder;
import me.hsgamer.bettergui.config.MessageConfig;
import me.hsgamer.bettergui.lib.core.bukkit.utils.MessageUtils;
import me.hsgamer.bettergui.lib.core.common.StringReplacer;
import me.hsgamer.bettergui.lib.core.common.Validate;
import me.hsgamer.bettergui.util.StringReplacerApplier;
import org.apache.commons.lang.time.DurationFormatUtils;

public class CooldownRequirement
extends BaseRequirement<Duration> {
    private final Map<UUID, Instant> cooldownMap = new HashMap<UUID, Instant>();

    public CooldownRequirement(RequirementBuilder.Input input) {
        super(input);
        this.getMenu().getVariableManager().register(this.getName(), StringReplacer.of((original, uuid) -> {
            long millis = this.getCooldown((UUID)uuid);
            long l = millis = millis > 0L ? millis : 0L;
            if (original.toLowerCase().startsWith("_format_")) {
                return DurationFormatUtils.formatDuration((long)millis, (String)original.substring("_format_".length()));
            }
            switch (original.toLowerCase()) {
                case "_s": 
                case "_seconds": {
                    return String.valueOf(millis / 1000L);
                }
                case "_m": 
                case "_minutes": {
                    return String.valueOf(millis / 60000L);
                }
                case "_h": 
                case "_hours": {
                    return String.valueOf(millis / 3600000L);
                }
            }
            return String.valueOf(millis);
        }));
    }

    @Override
    protected Duration convert(Object value, UUID uuid) {
        String replaced = StringReplacerApplier.replace(String.valueOf(value).trim(), uuid, this);
        return Validate.getNumber(replaced).map(bigDecimal -> Duration.ofMillis((long)bigDecimal.doubleValue() * 1000L)).orElseGet(() -> {
            MessageUtils.sendMessage(uuid, BetterGUI.getInstance().get(MessageConfig.class).getInvalidNumber(replaced));
            return Duration.ZERO;
        });
    }

    @Override
    protected Requirement.Result checkConverted(UUID uuid, Duration value) {
        if (this.getCooldown(uuid) <= 0L) {
            return Requirement.Result.success(uuid1 -> {
                if (!value.isNegative() && !value.isZero()) {
                    this.cooldownMap.put((UUID)uuid1, Instant.now().plus(value));
                }
            });
        }
        return Requirement.Result.fail();
    }

    private long getCooldown(UUID uuid) {
        if (this.cooldownMap.containsKey(uuid)) {
            return Instant.now().until(this.cooldownMap.get(uuid), ChronoUnit.MILLIS);
        }
        return 0L;
    }
}

