/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.requirement;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.hsgamer.bettergui.action.ActionApplier;
import me.hsgamer.bettergui.api.menu.Menu;
import me.hsgamer.bettergui.api.process.ProcessApplier;
import me.hsgamer.bettergui.api.requirement.Requirement;
import me.hsgamer.bettergui.builder.RequirementBuilder;
import me.hsgamer.bettergui.lib.core.collections.map.CaseInsensitiveStringMap;
import me.hsgamer.bettergui.lib.core.common.MapUtils;
import me.hsgamer.bettergui.lib.core.task.element.TaskPool;
import me.hsgamer.bettergui.lib.core.task.element.TaskProcess;

public class RequirementSet
implements Requirement {
    private final String name;
    private final Menu menu;
    private final List<Requirement> requirements;
    private final ActionApplier successActionApplier;
    private final ActionApplier failActionApplier;

    public RequirementSet(Menu menu, String name, Map<String, Object> section) {
        this.name = name;
        this.menu = menu;
        this.requirements = section.entrySet().stream().flatMap(entry -> {
            String type = (String)entry.getKey();
            Object value = entry.getValue();
            return RequirementBuilder.INSTANCE.build(new RequirementBuilder.Input(menu, type, name + "_" + type, value)).map(Stream::of).orElse(Stream.empty());
        }).collect(Collectors.toList());
        CaseInsensitiveStringMap<Object> keys = new CaseInsensitiveStringMap<Object>(section);
        this.successActionApplier = Optional.ofNullable(MapUtils.getIfFound(keys, "success-command", "success-action")).map(o -> new ActionApplier(menu, o)).orElse(ActionApplier.EMPTY);
        this.failActionApplier = Optional.ofNullable(MapUtils.getIfFound(keys, "fail-command", "fail-action")).map(o -> new ActionApplier(menu, o)).orElse(ActionApplier.EMPTY);
    }

    public List<Requirement> getRequirements() {
        return this.requirements;
    }

    public ActionApplier getSuccessActionApplier() {
        return this.successActionApplier;
    }

    public ActionApplier getFailActionApplier() {
        return this.failActionApplier;
    }

    @Override
    public Requirement.Result check(UUID uuid) {
        ArrayList<ProcessApplier> processAppliers = new ArrayList<ProcessApplier>();
        boolean success = true;
        for (Requirement requirement : this.requirements) {
            Requirement.Result result = requirement.check(uuid);
            if (result.isSuccess) {
                processAppliers.add(result.applier);
                continue;
            }
            success = false;
            break;
        }
        if (success) {
            return Requirement.Result.success((uuid1, process) -> {
                TaskPool taskPool = process.getCurrentTaskPool();
                processAppliers.forEach(processApplier -> taskPool.addLast(subProcess -> processApplier.accept(uuid1, subProcess)));
                this.successActionApplier.accept((UUID)uuid1, (TaskProcess)process);
            });
        }
        return Requirement.Result.fail(this.failActionApplier);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Menu getMenu() {
        return this.menu;
    }
}

