/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.modifier;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import me.hsgamer.bettergui.lib.core.bukkit.item.modifier.ItemMetaModifier;
import me.hsgamer.bettergui.lib.core.bukkit.utils.VersionUtils;
import me.hsgamer.bettergui.lib.core.common.StringReplacer;
import me.hsgamer.bettergui.lib.core.common.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkullModifier
implements ItemMetaModifier {
    private static final Pattern MOJANG_SHA256_APPROX_PATTERN;
    private static final Pattern BASE64_PATTERN;
    private static final SkullMeta delegateSkullMeta;
    private static final SkullHandler skullHandler;
    private String skullString = "";

    private static SkullHandler getSkullHandler() {
        try {
            Class.forName("org.bukkit.profile.PlayerProfile");
            return new NewSkullHandler();
        }
        catch (ClassNotFoundException e) {
            return new OldSkullHandler();
        }
    }

    private static void setSkull(SkullMeta meta, String skull) {
        Optional<URL> url = Validate.getURL(skull);
        if (url.isPresent()) {
            skullHandler.setSkullByURL(meta, url.get());
            return;
        }
        if (MOJANG_SHA256_APPROX_PATTERN.matcher(skull).matches()) {
            skullHandler.setSkullByURL(meta, "https://textures.minecraft.net/texture/" + skull);
            return;
        }
        if (BASE64_PATTERN.matcher(skull).matches()) {
            skullHandler.setSkullByBase64(meta, skull);
            return;
        }
        Optional<UUID> uuid = Validate.getUUID(skull);
        if (uuid.isPresent()) {
            skullHandler.setSkullByUUID(meta, uuid.get());
            return;
        }
        skullHandler.setSkullByName(meta, skull);
    }

    private static SkullMeta getSkullMeta(String skull) {
        SkullMeta meta = delegateSkullMeta.clone();
        SkullModifier.setSkull(meta, skull);
        return meta;
    }

    @Override
    @NotNull
    public ItemMeta modifyMeta(@NotNull ItemMeta meta, @Nullable UUID uuid, @NotNull StringReplacer stringReplacer) {
        if (!(meta instanceof SkullMeta)) {
            return meta;
        }
        SkullModifier.setSkull((SkullMeta)meta, stringReplacer.replaceOrOriginal(this.skullString, uuid));
        return meta;
    }

    @Override
    public boolean loadFromItemMeta(ItemMeta meta) {
        if (meta instanceof SkullMeta) {
            this.skullString = skullHandler.getSkullValue((SkullMeta)meta);
            return true;
        }
        return false;
    }

    @Override
    public Object toObject() {
        return this.skullString;
    }

    @Override
    public void loadFromObject(Object object) {
        this.skullString = String.valueOf(object);
    }

    static {
        ItemStack itemStack;
        MOJANG_SHA256_APPROX_PATTERN = Pattern.compile("[0-9a-z]{55,70}");
        BASE64_PATTERN = Pattern.compile("[-A-Za-z0-9+/]{100,}={0,3}");
        skullHandler = SkullModifier.getSkullHandler();
        if (VersionUtils.isAtLeast(13)) {
            itemStack = new ItemStack(Material.valueOf((String)"PLAYER_HEAD"));
        } else {
            itemStack = new ItemStack(Material.valueOf((String)"SKULL_ITEM"));
            itemStack.setDurability((short)3);
        }
        delegateSkullMeta = (SkullMeta)Objects.requireNonNull(itemStack.getItemMeta());
    }

    private static class NewSkullHandler
    implements SkullHandler {
        private final Map<String, PlayerProfile> profileMap = new ConcurrentHashMap<String, PlayerProfile>();

        private NewSkullHandler() {
        }

        @Override
        public void setSkullByPlayer(SkullMeta meta, OfflinePlayer player) {
            meta.setOwningPlayer(player);
        }

        @Override
        public void setSkullByURL(SkullMeta meta, URL url) {
            PlayerProfile profile = this.profileMap.computeIfAbsent(url.toString(), u -> {
                PlayerProfile newProfile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID(), (String)"");
                PlayerTextures textures = newProfile.getTextures();
                textures.setSkin(url);
                return newProfile;
            });
            meta.setOwnerProfile(profile);
        }

        @Override
        public void setSkullByBase64(SkullMeta meta, String base64) {
            try {
                String decoded = new String(Base64.getDecoder().decode(base64), StandardCharsets.UTF_8);
                JsonObject json = (JsonObject)new Gson().fromJson(decoded, JsonObject.class);
                String url = json.getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString();
                this.setSkullByURL(meta, url);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String getSkullValue(SkullMeta meta) {
            PlayerProfile profile = meta.getOwnerProfile();
            if (profile == null) {
                return "";
            }
            PlayerTextures textures = profile.getTextures();
            URL url = textures.getSkin();
            if (url == null) {
                return "";
            }
            return url.toString();
        }
    }

    private static class OldSkullHandler
    implements SkullHandler {
        private final Map<String, GameProfile> cache = new ConcurrentHashMap<String, GameProfile>();
        private final Method getProfileMethod;

        private OldSkullHandler() {
            Method method = null;
            try {
                method = Property.class.getDeclaredMethod("value", new Class[0]);
            }
            catch (Exception e) {
                try {
                    method = Property.class.getDeclaredMethod("getValue", new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            this.getProfileMethod = method;
        }

        @Override
        public void setSkullByPlayer(SkullMeta meta, OfflinePlayer player) {
            if (VersionUtils.isAtLeast(12)) {
                meta.setOwningPlayer(player);
            } else {
                meta.setOwner(player.getName());
            }
        }

        private void setSkullByGameProfile(SkullMeta meta, GameProfile profile) {
            try {
                Method setProfile = meta.getClass().getMethod("setProfile", GameProfile.class);
                setProfile.setAccessible(true);
                setProfile.invoke((Object)meta, profile);
            }
            catch (Exception e) {
                try {
                    Field profileField = meta.getClass().getDeclaredField("profile");
                    profileField.setAccessible(true);
                    profileField.set(meta, profile);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public void setSkullByURL(SkullMeta meta, URL url) {
            GameProfile profile = this.cache.computeIfAbsent(url.toString(), url1 -> {
                GameProfile gameProfile = new GameProfile(UUID.randomUUID(), "");
                gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", Base64.getEncoder().encodeToString(String.format("{textures:{SKIN:{url:\"%s\"}}}", url1).getBytes())));
                return gameProfile;
            });
            this.setSkullByGameProfile(meta, profile);
        }

        @Override
        public void setSkullByBase64(SkullMeta meta, String base64) {
            GameProfile gameProfile = this.cache.computeIfAbsent(base64, b -> {
                GameProfile profile = new GameProfile(UUID.randomUUID(), "");
                profile.getProperties().put((Object)"textures", (Object)new Property("textures", b));
                return profile;
            });
            this.setSkullByGameProfile(meta, gameProfile);
        }

        @Override
        public String getSkullValue(SkullMeta meta) {
            GameProfile profile;
            try {
                Field profileField = meta.getClass().getDeclaredField("profile");
                profileField.setAccessible(true);
                profile = (GameProfile)profileField.get(meta);
            }
            catch (Exception e) {
                return "";
            }
            Collection properties = profile.getProperties().get((Object)"textures");
            if (properties == null || properties.isEmpty()) {
                return "";
            }
            for (Property property : properties) {
                String value;
                try {
                    value = (String)this.getProfileMethod.invoke((Object)property, new Object[0]);
                }
                catch (Exception e) {
                    continue;
                }
                if (value.isEmpty()) continue;
                return value;
            }
            return "";
        }
    }

    private static interface SkullHandler {
        default public void setSkullByName(SkullMeta meta, String name) {
            this.setSkullByPlayer(meta, Bukkit.getOfflinePlayer((String)name));
        }

        default public void setSkullByUUID(SkullMeta meta, UUID uuid) {
            this.setSkullByPlayer(meta, Bukkit.getOfflinePlayer((UUID)uuid));
        }

        public void setSkullByPlayer(SkullMeta var1, OfflinePlayer var2);

        public void setSkullByURL(SkullMeta var1, URL var2);

        default public void setSkullByURL(SkullMeta meta, String url) {
            try {
                this.setSkullByURL(meta, new URL(url));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void setSkullByBase64(SkullMeta var1, String var2);

        public String getSkullValue(SkullMeta var1);
    }
}

