/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.modifier;

import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import me.hsgamer.bettergui.lib.core.bukkit.utils.VersionUtils;
import me.hsgamer.bettergui.lib.core.common.StringReplacer;
import me.hsgamer.bettergui.lib.core.minecraft.item.ItemModifier;
import me.hsgamer.bettergui.lib.craftitem.nbt.NBTMapNormalizer;
import me.hsgamer.bettergui.lib.craftitem.nbt.SNBTConverter;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class NBTModifier
implements ItemModifier<ItemStack> {
    private static final boolean USE_ITEM_COMPONENT = VersionUtils.isAtLeast(20, 5);
    private Object value;

    @Override
    @NotNull
    public ItemStack modify(@NotNull ItemStack original, UUID uuid, @NotNull StringReplacer stringReplacer) {
        String nbtString;
        if (this.value instanceof Map) {
            Object normalized = NBTMapNormalizer.normalize(this.value, s -> stringReplacer.replaceOrOriginal((String)s, uuid));
            nbtString = SNBTConverter.convert(normalized, USE_ITEM_COMPONENT);
        } else {
            nbtString = stringReplacer.replaceOrOriginal(Objects.toString(this.value), uuid);
        }
        ItemStack appliedItemStack = this.applyNBT(original, nbtString);
        return appliedItemStack == null ? original : appliedItemStack;
    }

    private ItemStack applyNBT(ItemStack item, String nbtString) {
        try {
            if (USE_ITEM_COMPONENT) {
                String materialName = item.getType().getKey().toString();
                return Bukkit.getItemFactory().createItemStack(materialName + nbtString);
            }
            return Bukkit.getUnsafe().modifyItemStack(item, nbtString);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public Object toObject() {
        return this.value;
    }

    @Override
    public void loadFromObject(Object object) {
        this.value = object;
    }
}

