/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.menu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import me.hsgamer.bettergui.BetterGUI;
import me.hsgamer.bettergui.api.menu.StandardMenu;
import me.hsgamer.bettergui.api.requirement.Requirement;
import me.hsgamer.bettergui.argument.ArgumentHandler;
import me.hsgamer.bettergui.lib.core.bukkit.utils.PermissionUtils;
import me.hsgamer.bettergui.lib.core.collections.map.CaseInsensitiveStringMap;
import me.hsgamer.bettergui.lib.core.common.CollectionUtils;
import me.hsgamer.bettergui.lib.core.common.MapUtils;
import me.hsgamer.bettergui.lib.core.common.Pair;
import me.hsgamer.bettergui.lib.core.config.Config;
import me.hsgamer.bettergui.lib.core.task.BatchRunnable;
import me.hsgamer.bettergui.manager.MenuCommandManager;
import me.hsgamer.bettergui.manager.MenuManager;
import me.hsgamer.bettergui.requirement.RequirementApplier;
import me.hsgamer.bettergui.util.SchedulerUtil;
import me.hsgamer.bettergui.util.StringReplacerApplier;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;

public class PredicateMenu
extends StandardMenu {
    private final List<Pair<RequirementApplier, MenuProcess>> menuPredicateList;
    private final List<Permission> permissions;
    private final ArgumentHandler argumentHandler;

    public PredicateMenu(Config config) {
        super(config);
        this.permissions = Optional.ofNullable(this.menuSettings.get("permission")).map(o -> CollectionUtils.createStringListFromObject(o, true)).map(l -> l.stream().map(Permission::new).collect(Collectors.toList())).orElse(Collections.singletonList(new Permission(BetterGUI.getInstance().getName().toLowerCase() + "." + this.getName())));
        Optional.ofNullable(this.menuSettings.get("command")).map(o -> CollectionUtils.createStringListFromObject(o, true)).ifPresent(list -> {
            for (String s : list) {
                if (s.contains(" ")) {
                    BetterGUI.getInstance().getLogger().warning("Illegal characters in command '" + s + "'in the menu '" + this.getName() + "'. Ignored");
                    continue;
                }
                BetterGUI.getInstance().get(MenuCommandManager.class).registerMenuCommand(s, this);
            }
        });
        this.argumentHandler = Optional.ofNullable(MapUtils.getIfFound(this.menuSettings, "argument-processor", "arg-processor", "argument", "arg")).flatMap(MapUtils::castOptionalStringObjectMap).map(m -> new ArgumentHandler(this, (Map<String, Object>)m)).orElseGet(() -> new ArgumentHandler(this, Collections.emptyMap()));
        this.menuPredicateList = new ArrayList<Pair<RequirementApplier, MenuProcess>>();
        this.configSettings.forEach((key, value) -> {
            if (!(value instanceof Map)) {
                return;
            }
            CaseInsensitiveStringMap values = new CaseInsensitiveStringMap((Map)value);
            String menu = Objects.toString(values.get("menu"), null);
            if (menu == null) {
                return;
            }
            String args = Optional.ofNullable(MapUtils.getIfFound(values, "args", "arguments", "arg", "argument")).map(Object::toString).orElse("");
            Map requirementValue = MapUtils.castOptionalStringObjectMap(values.get("requirement")).orElseGet(Collections::emptyMap);
            this.menuPredicateList.add(Pair.of(new RequirementApplier(this, this.getName() + "_" + key + "_requirement", requirementValue), new MenuProcess(menu, args)));
        });
    }

    @Override
    public boolean create(Player player, String[] args, boolean bypass) {
        UUID uuid = player.getUniqueId();
        if (!this.argumentHandler.process(uuid, args).isPresent()) {
            return false;
        }
        if (!bypass && !PermissionUtils.hasAnyPermission(player, this.permissions)) {
            return false;
        }
        boolean isSuccessful = false;
        for (Pair<RequirementApplier, MenuProcess> pair : this.menuPredicateList) {
            Requirement.Result result = pair.getKey().getResult(uuid);
            BatchRunnable batchRunnable = new BatchRunnable();
            batchRunnable.getTaskPool(9).addLast(process -> {
                result.applier.accept(uuid, process);
                process.next();
            });
            SchedulerUtil.async().run(batchRunnable);
            if (!result.isSuccess) continue;
            MenuProcess menuProcess = pair.getValue();
            String[] finalArgs = StringReplacerApplier.replace(menuProcess.args, uuid, this).split("\\s+");
            BetterGUI.getInstance().get(MenuManager.class).openMenu(menuProcess.menu, player, finalArgs, this.getParentMenu(uuid).orElse(null), bypass);
            isSuccessful = true;
            break;
        }
        return isSuccessful;
    }

    @Override
    public List<String> tabComplete(Player player, String[] args) {
        return this.argumentHandler.handleTabComplete(player.getUniqueId(), args);
    }

    @Override
    public void update(Player player) {
    }

    @Override
    public void close(Player player) {
    }

    @Override
    public void closeAll() {
    }

    private static final class MenuProcess {
        private final String menu;
        private final String args;

        private MenuProcess(String menu, String args) {
            this.menu = menu;
            this.args = args;
        }
    }
}

