/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.menu;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import me.hsgamer.bettergui.BetterGUI;
import me.hsgamer.bettergui.action.ActionApplier;
import me.hsgamer.bettergui.api.menu.StandardMenu;
import me.hsgamer.bettergui.api.requirement.Requirement;
import me.hsgamer.bettergui.argument.ArgumentHandler;
import me.hsgamer.bettergui.config.MessageConfig;
import me.hsgamer.bettergui.lib.core.bukkit.utils.MessageUtils;
import me.hsgamer.bettergui.lib.core.bukkit.utils.PermissionUtils;
import me.hsgamer.bettergui.lib.core.common.CollectionUtils;
import me.hsgamer.bettergui.lib.core.common.MapUtils;
import me.hsgamer.bettergui.lib.core.config.Config;
import me.hsgamer.bettergui.lib.core.task.BatchRunnable;
import me.hsgamer.bettergui.manager.MenuCommandManager;
import me.hsgamer.bettergui.requirement.RequirementApplier;
import me.hsgamer.bettergui.util.SchedulerUtil;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;

public abstract class BaseMenu
extends StandardMenu {
    protected final ActionApplier openActionApplier;
    protected final ActionApplier closeActionApplier;
    protected final RequirementApplier viewRequirementApplier;
    protected final RequirementApplier closeRequirementApplier;
    protected final List<Permission> permissions;
    protected final ArgumentHandler argumentHandler;

    protected BaseMenu(Config config) {
        super(config);
        this.openActionApplier = Optional.ofNullable(this.menuSettings.get("open-action")).map(o -> new ActionApplier(this, o)).orElse(ActionApplier.EMPTY);
        this.closeActionApplier = Optional.ofNullable(this.menuSettings.get("close-action")).map(o -> new ActionApplier(this, o)).orElse(ActionApplier.EMPTY);
        this.viewRequirementApplier = Optional.ofNullable(this.menuSettings.get("view-requirement")).flatMap(MapUtils::castOptionalStringObjectMap).map(m -> new RequirementApplier(this, this.getName() + "_view", (Map<String, Object>)m)).orElse(RequirementApplier.EMPTY);
        this.closeRequirementApplier = Optional.ofNullable(this.menuSettings.get("close-requirement")).flatMap(MapUtils::castOptionalStringObjectMap).map(m -> new RequirementApplier(this, this.getName() + "_close", (Map<String, Object>)m)).orElse(RequirementApplier.EMPTY);
        this.permissions = Optional.ofNullable(this.menuSettings.get("permission")).map(o -> CollectionUtils.createStringListFromObject(o, true)).map(l -> l.stream().map(Permission::new).collect(Collectors.toList())).orElseGet(() -> Collections.singletonList(new Permission(BetterGUI.getInstance().getName().toLowerCase() + "." + this.getName())));
        this.argumentHandler = Optional.ofNullable(MapUtils.getIfFound(this.menuSettings, "argument-processor", "arg-processor", "argument", "arg")).flatMap(MapUtils::castOptionalStringObjectMap).map(m -> new ArgumentHandler(this, (Map<String, Object>)m)).orElseGet(() -> new ArgumentHandler(this, Collections.emptyMap()));
        Optional.ofNullable(this.menuSettings.get("command")).map(o -> CollectionUtils.createStringListFromObject(o, true)).ifPresent(list -> {
            for (String s : list) {
                if (s.contains(" ")) {
                    BetterGUI.getInstance().getLogger().warning("Illegal characters in command '" + s + "'in the menu '" + this.getName() + "'. Ignored");
                    continue;
                }
                BetterGUI.getInstance().get(MenuCommandManager.class).registerMenuCommand(s, this);
            }
        });
    }

    protected abstract boolean createChecked(Player var1, String[] var2, boolean var3);

    @Override
    public boolean create(Player player, String[] args, boolean bypass) {
        UUID uuid = player.getUniqueId();
        if (!this.argumentHandler.process(uuid, args).isPresent()) {
            return false;
        }
        if (!bypass && !PermissionUtils.hasAnyPermission(player, this.permissions)) {
            MessageUtils.sendMessage((CommandSender)player, BetterGUI.getInstance().get(MessageConfig.class).getNoPermission());
            return false;
        }
        if (!bypass) {
            Requirement.Result result = this.viewRequirementApplier.getResult(uuid);
            BatchRunnable batchRunnable = new BatchRunnable();
            batchRunnable.getTaskPool(9).addLast(process -> {
                result.applier.accept(uuid, process);
                process.next();
            });
            SchedulerUtil.async().run(batchRunnable);
            if (!result.isSuccess) {
                return false;
            }
        }
        return this.createChecked(player, args, bypass);
    }

    @Override
    public List<String> tabComplete(Player player, String[] args) {
        return this.argumentHandler.handleTabComplete(player.getUniqueId(), args);
    }

    public ArgumentHandler getArgumentHandler() {
        return this.argumentHandler;
    }
}

