/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.manager;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import me.hsgamer.bettergui.BetterGUI;
import me.hsgamer.bettergui.lib.core.bukkit.expansion.BukkitConfigExpansionDescriptionLoader;
import me.hsgamer.bettergui.lib.core.bukkit.utils.BukkitUtils;
import me.hsgamer.bettergui.lib.core.common.CollectionUtils;
import me.hsgamer.bettergui.lib.core.common.MapUtils;
import me.hsgamer.bettergui.lib.core.common.Validate;
import me.hsgamer.bettergui.lib.core.expansion.common.ExpansionClassLoader;
import me.hsgamer.bettergui.lib.core.expansion.common.ExpansionManager;
import me.hsgamer.bettergui.lib.core.expansion.common.ExpansionState;
import me.hsgamer.bettergui.lib.core.expansion.common.exception.InvalidExpansionDescriptionException;
import me.hsgamer.bettergui.lib.core.expansion.extra.manager.DependableExpansionSortAndFilter;
import me.hsgamer.bettergui.lib.minelib.plugin.base.Loadable;
import me.hsgamer.bettergui.lib.minelib.plugin.postenable.PostEnable;
import org.jetbrains.annotations.NotNull;

public class AddonManager
extends ExpansionManager
implements Loadable,
PostEnable {
    private final BetterGUI plugin;

    public AddonManager(BetterGUI plugin) {
        super(new File(plugin.getDataFolder(), "addon"), new BukkitConfigExpansionDescriptionLoader("addon.yml"), plugin.getClass().getClassLoader());
        this.plugin = plugin;
        this.setSortAndFilterFunction(new DependableExpansionSortAndFilter(){

            @Override
            public List<String> getDependencies(ExpansionClassLoader loader) {
                return CollectionUtils.createStringListFromObject(MapUtils.getIfFound(loader.getDescription().getData(), "depend", "depends", "dependencies"));
            }

            @Override
            public List<String> getSoftDependencies(ExpansionClassLoader loader) {
                return CollectionUtils.createStringListFromObject(MapUtils.getIfFound(loader.getDescription().getData(), "softdepend", "softdepends", "soft-dependencies"));
            }
        });
        this.addStateListener((loader, state) -> {
            if (state == ExpansionState.LOADING) {
                this.checkPluginDepends((ExpansionClassLoader)loader);
            } else if (state == ExpansionState.ERROR) {
                plugin.getLogger().log(Level.WARNING, "There is an error when loading an addon: " + loader.getDescription().getName(), loader.getThrowable());
            } else if (state == ExpansionState.ENABLED) {
                plugin.getLogger().log(Level.INFO, "Enabled " + loader.getDescription().getName() + " " + loader.getDescription().getVersion());
            } else if (state == ExpansionState.DISABLED) {
                plugin.getLogger().log(Level.INFO, "Disabled " + loader.getDescription().getName() + " " + loader.getDescription().getVersion());
            }
        });
        this.setExceptionHandler(throwable -> plugin.getLogger().log(Level.SEVERE, "There is an error when handling an addon", (Throwable)throwable));
    }

    @NotNull
    public static @NotNull List<@NotNull String> getAuthors(@NotNull ExpansionClassLoader loader) {
        Object value = MapUtils.getIfFound(loader.getDescription().getData(), "authors", "author");
        return CollectionUtils.createStringListFromObject(value, true);
    }

    @NotNull
    public static String getDescription(@NotNull ExpansionClassLoader loader) {
        Object value = loader.getDescription().getData().get("description");
        return Objects.toString(value, "");
    }

    @NotNull
    private static @NotNull List<@NotNull String> getPluginDepends(@NotNull ExpansionClassLoader loader) {
        Object value = MapUtils.getIfFound(loader.getDescription().getData(), "plugin-depend", "plugin", "plugin-depends", "plugins");
        return CollectionUtils.createStringListFromObject(value, true);
    }

    private void checkPluginDepends(@NotNull ExpansionClassLoader loader) {
        List<String> requiredPlugins = AddonManager.getPluginDepends(loader);
        if (Validate.isNullOrEmpty(requiredPlugins)) {
            return;
        }
        List<String> missing = BukkitUtils.getMissingDepends(requiredPlugins);
        if (!missing.isEmpty()) {
            throw new InvalidExpansionDescriptionException("Missing plugin dependency for " + loader.getDescription().getName() + ": " + Arrays.toString(missing.toArray()));
        }
    }

    public Map<String, Integer> getExpansionCount() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        this.getEnabledExpansions().keySet().forEach(s -> map.put((String)s, 1));
        return map;
    }

    public BetterGUI getPlugin() {
        return this.plugin;
    }

    @Override
    public void enable() {
        this.loadExpansions();
    }

    @Override
    public void postEnable() {
        this.enableExpansions();
    }

    @Override
    public void disable() {
        this.disableExpansions();
        this.clearExpansions();
    }
}

