/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.craftitem.nbt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;

public final class NBTMapNormalizer {
    private NBTMapNormalizer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated.");
    }

    public static Object normalize(Object value) {
        return NBTMapNormalizer.normalize(value, s -> s);
    }

    public static Object normalize(Object value, UnaryOperator<String> translator) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Map)) {
            return value;
        }
        Map map = (Map)value;
        if (map.containsKey("$type")) {
            if (!map.containsKey("$value")) {
                throw new IllegalArgumentException("Map with '$type' entry must also have '$value' entry");
            }
            return NBTMapNormalizer.normalizeForcedValue(map.get("$type"), map.get("$value"), translator);
        }
        HashMap<String, Object> result = new HashMap<String, Object>(map);
        for (Map.Entry entry : result.entrySet()) {
            Object entryValue = entry.getValue();
            if (entryValue instanceof Map) {
                Map nested = (Map)entryValue;
                result.put((String)entry.getKey(), NBTMapNormalizer.normalize(nested, translator));
                continue;
            }
            if (!(entryValue instanceof List)) continue;
            result.put((String)entry.getKey(), NBTMapNormalizer.normalizeList((List)entryValue, translator));
        }
        return result;
    }

    private static Object normalizeForcedValue(Object type, Object value, UnaryOperator<String> translator) {
        String typeStr;
        if (!(type instanceof String)) {
            throw new IllegalArgumentException("Type must be a string");
        }
        switch (typeStr = ((String)type).toLowerCase()) {
            case "byte": {
                return NBTMapNormalizer.normalizeToByte(value, translator);
            }
            case "boolean": {
                return NBTMapNormalizer.normalizeToBoolean(value, translator);
            }
            case "short": {
                return NBTMapNormalizer.normalizeToShort(value, translator);
            }
            case "int": 
            case "integer": {
                return NBTMapNormalizer.normalizeToInt(value, translator);
            }
            case "long": {
                return NBTMapNormalizer.normalizeToLong(value, translator);
            }
            case "float": {
                return NBTMapNormalizer.normalizeToFloat(value, translator);
            }
            case "double": {
                return NBTMapNormalizer.normalizeToDouble(value, translator);
            }
            case "string": {
                return NBTMapNormalizer.normalizeToString(value, translator);
            }
            case "raw": {
                return NBTMapNormalizer.normalizeToRaw(value, translator);
            }
            case "list": {
                return NBTMapNormalizer.normalizeToList(value, translator);
            }
            case "compound": {
                return NBTMapNormalizer.normalize(value, translator);
            }
            case "byte_array": 
            case "bytearray": {
                return NBTMapNormalizer.normalizeToByteArray(value, translator);
            }
            case "int_array": 
            case "intarray": {
                return NBTMapNormalizer.normalizeToIntArray(value, translator);
            }
            case "long_array": 
            case "longarray": {
                return NBTMapNormalizer.normalizeToLongArray(value, translator);
            }
        }
        throw new IllegalArgumentException("Unknown type: " + typeStr);
    }

    private static List<?> normalizeList(List<?> list, UnaryOperator<String> translator) {
        ArrayList result = new ArrayList(list);
        for (int i = 0; i < result.size(); ++i) {
            Object item = result.get(i);
            if (item instanceof Map) {
                Map nested = (Map)item;
                result.set(i, NBTMapNormalizer.normalize(nested, translator));
                continue;
            }
            if (!(item instanceof List)) continue;
            result.set(i, NBTMapNormalizer.normalizeList((List)item, translator));
        }
        return result;
    }

    private static Byte normalizeToByte(Object value, UnaryOperator<String> translator) {
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            str = str.trim();
            if ((str = (String)translator.apply(str)).endsWith("b") || str.endsWith("B")) {
                str = str.substring(0, str.length() - 1);
            }
            return Byte.parseByte(str);
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to byte");
    }

    private static Boolean normalizeToBoolean(Object value, UnaryOperator<String> translator) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        if (value instanceof String) {
            String str = ((String)value).trim();
            str = (String)translator.apply(str);
            if ((str = str.toLowerCase()).equals("true")) {
                return true;
            }
            if (str.equals("false")) {
                return false;
            }
            try {
                int num = Integer.parseInt(str);
                return num != 0;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot convert " + value + " to boolean");
            }
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to boolean");
    }

    private static Short normalizeToShort(Object value, UnaryOperator<String> translator) {
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            str = str.trim();
            if ((str = (String)translator.apply(str)).endsWith("s") || str.endsWith("S")) {
                str = str.substring(0, str.length() - 1);
            }
            return Short.parseShort(str);
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to short");
    }

    private static Integer normalizeToInt(Object value, UnaryOperator<String> translator) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            str = str.trim();
            if ((str = (String)translator.apply(str)).endsWith("i") || str.endsWith("I")) {
                str = str.substring(0, str.length() - 1);
            }
            return Integer.parseInt(str);
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to int");
    }

    private static Long normalizeToLong(Object value, UnaryOperator<String> translator) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            str = str.trim();
            if ((str = (String)translator.apply(str)).endsWith("l") || str.endsWith("L")) {
                str = str.substring(0, str.length() - 1);
            }
            return Long.parseLong(str);
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to long");
    }

    private static Float normalizeToFloat(Object value, UnaryOperator<String> translator) {
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            String str = (String)value;
            str = str.trim();
            if ((str = (String)translator.apply(str)).endsWith("f") || str.endsWith("F")) {
                str = str.substring(0, str.length() - 1);
            }
            return Float.valueOf(Float.parseFloat(str));
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to float");
    }

    private static Double normalizeToDouble(Object value, UnaryOperator<String> translator) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            str = str.trim();
            if ((str = (String)translator.apply(str)).endsWith("d") || str.endsWith("D")) {
                str = str.substring(0, str.length() - 1);
            }
            return Double.parseDouble(str);
        }
        throw new IllegalArgumentException("Cannot convert " + value + " to double");
    }

    private static String normalizeToString(Object value, UnaryOperator<String> translator) {
        return (String)translator.apply(value.toString());
    }

    private static Object normalizeToRaw(Object value, UnaryOperator<String> translator) {
        String rawValue = (String)translator.apply(value.toString());
        HashMap<String, Object> rawMap = new HashMap<String, Object>();
        rawMap.put("$raw", true);
        rawMap.put("$value", rawValue);
        return rawMap;
    }

    private static List<?> normalizeToList(Object value, UnaryOperator<String> translator) {
        if (!(value instanceof List)) {
            throw new IllegalArgumentException("Value must be a List");
        }
        return NBTMapNormalizer.normalizeList((List)value, translator);
    }

    private static byte[] normalizeToByteArray(Object value, UnaryOperator<String> translator) {
        byte[] arr;
        if (value instanceof byte[]) {
            arr = (byte[])value;
        } else if (value instanceof List) {
            List list = (List)value;
            arr = new byte[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Object item = list.get(i);
                arr[i] = item instanceof String ? NBTMapNormalizer.normalizeToByte(item, translator).byteValue() : ((Number)item).byteValue();
            }
        } else {
            throw new IllegalArgumentException("Value must be byte[] or List");
        }
        return arr;
    }

    private static int[] normalizeToIntArray(Object value, UnaryOperator<String> translator) {
        int[] arr;
        if (value instanceof int[]) {
            arr = (int[])value;
        } else if (value instanceof List) {
            List list = (List)value;
            arr = new int[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Object item = list.get(i);
                arr[i] = item instanceof String ? NBTMapNormalizer.normalizeToInt(item, translator).intValue() : ((Number)item).intValue();
            }
        } else {
            throw new IllegalArgumentException("Value must be int[] or List");
        }
        return arr;
    }

    private static long[] normalizeToLongArray(Object value, UnaryOperator<String> translator) {
        long[] arr;
        if (value instanceof long[]) {
            arr = (long[])value;
        } else if (value instanceof List) {
            List list = (List)value;
            arr = new long[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Object item = list.get(i);
                arr[i] = item instanceof String ? NBTMapNormalizer.normalizeToLong(item, translator).longValue() : ((Number)item).longValue();
            }
        } else {
            throw new IllegalArgumentException("Value must be long[] or List");
        }
        return arr;
    }
}

