/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.variable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.hsgamer.bettergui.lib.core.common.StringReplacer;
import me.hsgamer.bettergui.lib.core.variable.Variable;
import me.hsgamer.bettergui.lib.core.variable.VariableSession;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableManager
implements StringReplacer {
    public static final VariableManager GLOBAL = new VariableManager();
    private final Function<String, VariableSession> sessionFunction;
    private final List<Variable> variableEntries = new ArrayList<Variable>();
    private final List<StringReplacer> externalReplacers = new ArrayList<StringReplacer>();

    public VariableManager(Function<String, VariableSession> sessionFunction) {
        this.sessionFunction = sessionFunction;
    }

    public VariableManager(final char startIgnoreChar, final char endIgnoreChar) {
        this(new Function<String, VariableSession>(){
            private final Pattern pattern = Pattern.compile("(.?)([{]([^{}]+)[}])(.?)");

            @Override
            public VariableSession apply(final String s) {
                return new VariableSession(){
                    private final Matcher matcher;
                    private final StringBuffer stringBuffer;
                    {
                        this.matcher = pattern.matcher(s);
                        this.stringBuffer = new StringBuffer();
                    }

                    @Override
                    public boolean hasVariable() {
                        while (this.matcher.find()) {
                            char startChar = Optional.ofNullable(this.matcher.group(1)).filter(s -> !s.isEmpty()).map(s -> Character.valueOf(s.charAt(0))).orElse(Character.valueOf(' ')).charValue();
                            char endChar = Optional.ofNullable(this.matcher.group(4)).filter(s -> !s.isEmpty()).map(s -> Character.valueOf(s.charAt(0))).orElse(Character.valueOf(' ')).charValue();
                            if (startIgnoreChar == startChar && endIgnoreChar == endChar) {
                                String original = this.matcher.group(2);
                                this.matcher.appendReplacement(this.stringBuffer, Matcher.quoteReplacement(original));
                                continue;
                            }
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public String getVariable() {
                        return this.matcher.group(3).trim();
                    }

                    @Override
                    public void replaceVariable(String replacement) {
                        String startChar = Optional.ofNullable(this.matcher.group(1)).filter(s -> !s.isEmpty()).orElse("");
                        String endChar = Optional.ofNullable(this.matcher.group(4)).filter(s -> !s.isEmpty()).orElse("");
                        this.matcher.appendReplacement(this.stringBuffer, Matcher.quoteReplacement(startChar + replacement + endChar));
                    }

                    @Override
                    public String getFinalString() {
                        this.matcher.appendTail(this.stringBuffer);
                        return this.stringBuffer.toString();
                    }
                };
            }
        });
    }

    public VariableManager() {
        this('\\', '\\');
    }

    public void register(String prefix, StringReplacer variable, boolean isWhole) {
        this.variableEntries.add(new Variable(prefix, isWhole, variable));
    }

    public void register(String prefix, StringReplacer variable) {
        this.register(prefix, variable, false);
    }

    public void unregister(String prefix) {
        this.variableEntries.removeIf(entry -> entry.prefix.equalsIgnoreCase(prefix));
    }

    public Map<String, StringReplacer> getVariables() {
        return this.variableEntries.stream().collect(HashMap::new, (map, entry) -> map.put(entry.prefix, entry.replacer), HashMap::putAll);
    }

    public List<Variable> getVariableEntries() {
        return Collections.unmodifiableList(this.variableEntries);
    }

    public void addExternalReplacer(StringReplacer replacer) {
        this.externalReplacers.add(replacer);
    }

    public void removeExternalReplacer(StringReplacer replacer) {
        this.externalReplacers.remove(replacer);
    }

    public void clearExternalReplacers() {
        this.externalReplacers.clear();
    }

    public List<StringReplacer> getExternalReplacers() {
        return Collections.unmodifiableList(this.externalReplacers);
    }

    @NotNull
    public String setVariables(@NotNull String message, @Nullable UUID uuid) {
        String old;
        while (!(old = message).equals(message = this.setSingleVariables(message, uuid))) {
        }
        return message;
    }

    @NotNull
    public String setSingleVariables(@NotNull String message, @Nullable UUID uuid) {
        VariableSession session = this.sessionFunction.apply(message);
        while (session.hasVariable()) {
            String identifier = session.getVariable();
            this.variableEntries.stream().filter(entry -> entry.isWhole ? identifier.equalsIgnoreCase(entry.prefix) : identifier.toLowerCase(Locale.ROOT).startsWith(entry.prefix.toLowerCase(Locale.ROOT))).findFirst().map(entry -> entry.replacer.tryReplace(identifier.substring(entry.prefix.length()), uuid)).ifPresent(session::replaceVariable);
        }
        message = session.getFinalString();
        for (StringReplacer externalStringReplacer : this.externalReplacers) {
            String replaced = externalStringReplacer.tryReplace(message, uuid);
            if (replaced == null) continue;
            message = replaced;
        }
        return message;
    }

    @Override
    @Nullable
    public String replace(@NotNull String original) {
        return this.setVariables(original, null);
    }

    @Override
    @Nullable
    public String replace(@NotNull String original, @NotNull UUID uuid) {
        return this.setVariables(original, uuid);
    }
}

