/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.task;

import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import me.hsgamer.bettergui.lib.core.task.element.TaskData;
import me.hsgamer.bettergui.lib.core.task.element.TaskPool;
import me.hsgamer.bettergui.lib.core.task.element.TaskProcess;

public class BatchRunnable
implements Runnable {
    private final Queue<TaskPool> tasks = new PriorityQueue<TaskPool>(Comparator.comparingInt(TaskPool::getStage));
    private final TaskData data;
    private final AtomicBoolean isTimeout = new AtomicBoolean(false);
    private long timeout = 0L;
    private TimeUnit timeoutUnit = TimeUnit.MILLISECONDS;

    public BatchRunnable(TaskData data) {
        this.data = data;
    }

    public BatchRunnable() {
        this(TaskData.create());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        final AtomicBoolean isRunning = new AtomicBoolean(true);
        final AtomicReference<TaskPool> currentTaskPool = new AtomicReference<TaskPool>();
        final AtomicBoolean isLocked = new AtomicBoolean(false);
        final Object lock = new Object();
        TaskProcess process = new TaskProcess(){

            @Override
            public TaskData getData() {
                return BatchRunnable.this.data;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void next() {
                Object object = lock;
                synchronized (object) {
                    isLocked.set(false);
                    lock.notify();
                }
            }

            @Override
            public void complete() {
                isRunning.set(false);
                this.next();
            }

            @Override
            public TaskPool getCurrentTaskPool() {
                return (TaskPool)currentTaskPool.get();
            }

            @Override
            public TaskPool getTaskPool(int stage) {
                return BatchRunnable.this.getTaskPool(stage);
            }
        };
        while (isRunning.get()) {
            Consumer<TaskProcess> task;
            TaskPool taskPool = (TaskPool)currentTaskPool.get();
            Consumer<TaskProcess> consumer = task = taskPool == null ? null : taskPool.pollTask();
            if (task == null) {
                taskPool = this.tasks.poll();
                if (taskPool == null) {
                    isRunning.set(false);
                    break;
                }
                currentTaskPool.set(taskPool);
                continue;
            }
            isLocked.set(true);
            task.accept(process);
            Object object = lock;
            synchronized (object) {
                if (isLocked.get()) {
                    try {
                        if (this.timeout <= 0L) {
                            lock.wait();
                        } else {
                            lock.wait(this.timeoutUnit.toMillis(this.timeout));
                            if (isLocked.get()) {
                                this.isTimeout.set(true);
                                throw new InterruptedException();
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        isRunning.set(false);
                        isLocked.set(false);
                        break;
                    }
                }
            }
        }
    }

    public TaskPool getTaskPool(int stage) {
        TaskPool taskPool = null;
        for (TaskPool t : this.tasks) {
            if (t.getStage() != stage) continue;
            taskPool = t;
            break;
        }
        if (taskPool == null) {
            taskPool = new TaskPool(stage);
            this.tasks.add(taskPool);
        }
        return taskPool;
    }

    public void addTaskPool(int stage, Consumer<TaskPool> taskPoolConsumer) {
        taskPoolConsumer.accept(this.getTaskPool(stage));
    }

    public void setTimeout(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.timeoutUnit = unit;
    }

    public boolean isTimeout() {
        return this.isTimeout.get();
    }

    public TaskData getData() {
        return this.data;
    }
}

