/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.minecraft.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import me.hsgamer.bettergui.lib.core.common.StringReplacer;
import me.hsgamer.bettergui.lib.core.minecraft.item.ItemModifier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ItemBuilder<T> {
    private final List<ItemModifier<T>> itemModifiers = new ArrayList<ItemModifier<T>>();
    private final List<StringReplacer> stringReplacers = new ArrayList<StringReplacer>();

    @NotNull
    protected abstract T getDefaultItem();

    @Contract(value="_ -> this")
    public ItemBuilder<T> addItemModifier(ItemModifier<T> modifier) {
        this.itemModifiers.add(modifier);
        return this;
    }

    @Contract(value="_ -> this")
    public ItemBuilder<T> removeItemModifier(ItemModifier<T> modifier) {
        this.itemModifiers.remove(modifier);
        return this;
    }

    public List<ItemModifier<T>> getItemModifiers() {
        return Collections.unmodifiableList(this.itemModifiers);
    }

    public List<StringReplacer> getStringReplacers() {
        return Collections.unmodifiableList(this.stringReplacers);
    }

    @Contract(value="_ -> this")
    public ItemBuilder<T> addStringReplacer(StringReplacer replacer) {
        this.stringReplacers.add(replacer);
        return this;
    }

    @Contract(value="_ -> this")
    public ItemBuilder<T> removeStringReplacer(StringReplacer replacer) {
        this.stringReplacers.remove(replacer);
        return this;
    }

    public T build(@Nullable UUID uuid) {
        T item = this.getDefaultItem();
        StringReplacer stringReplacer = StringReplacer.combine(this.stringReplacers);
        for (ItemModifier<T> modifier : this.itemModifiers) {
            item = modifier.modify(item, uuid, stringReplacer);
        }
        return item;
    }

    public T build() {
        return this.build(null);
    }
}

