/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.minecraft.gui.object;

import java.util.stream.IntStream;
import java.util.stream.Stream;
import me.hsgamer.bettergui.lib.core.minecraft.gui.object.InventoryPosition;

public interface InventorySize {
    public int getSize();

    default public int getSlotPerRow() {
        return this.getSize();
    }

    default public IntStream getSlots() {
        return IntStream.range(0, this.getSize());
    }

    default public InventoryPosition toPosition(int slot) {
        int slotPerRow = this.getSlotPerRow();
        int x = slot % slotPerRow;
        int y = slot / slotPerRow;
        return InventoryPosition.of(x, y);
    }

    default public IntStream toSlots(Stream<InventoryPosition> positions) {
        return positions.mapToInt(position -> position.toSlot(this));
    }
}

