/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.minecraft.gui.object;

import java.util.Objects;
import me.hsgamer.bettergui.lib.core.minecraft.gui.object.InventorySize;

public class InventoryPosition {
    private final int x;
    private final int y;

    private InventoryPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public static InventoryPosition of(int x, int y) {
        return new InventoryPosition(x, y);
    }

    public static InventoryPosition maxPosition(int x1, int y1, int x2, int y2) {
        return InventoryPosition.of(Math.max(x1, x2), Math.max(y1, y2));
    }

    public static InventoryPosition maxPosition(InventoryPosition position1, InventoryPosition position2) {
        return InventoryPosition.maxPosition(position1.getX(), position1.getY(), position2.getX(), position2.getY());
    }

    public static InventoryPosition minPosition(int x1, int y1, int x2, int y2) {
        return InventoryPosition.of(Math.min(x1, x2), Math.min(y1, y2));
    }

    public static InventoryPosition minPosition(InventoryPosition position1, InventoryPosition position2) {
        return InventoryPosition.minPosition(position1.getX(), position1.getY(), position2.getX(), position2.getY());
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int toSlot(InventorySize size) {
        return this.y * size.getSlotPerRow() + this.x;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InventoryPosition that = (InventoryPosition)o;
        return this.x == that.x && this.y == that.y;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }
}

