/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.minecraft.gui.button.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.hsgamer.bettergui.lib.core.animate.Animation;
import me.hsgamer.bettergui.lib.core.minecraft.gui.GUIProperties;
import me.hsgamer.bettergui.lib.core.minecraft.gui.button.Button;
import me.hsgamer.bettergui.lib.core.minecraft.gui.button.DisplayButton;
import me.hsgamer.bettergui.lib.core.ui.property.Initializable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class AnimatedButton
implements Button {
    private final List<Button> buttons = new ArrayList<Button>();
    private final Map<UUID, Animation<Button>> animationMap = new ConcurrentHashMap<UUID, Animation<Button>>();
    private long periodMillis = 50L;

    @Contract(value="_ -> this")
    public AnimatedButton setPeriodMillis(long periodMillis) {
        if (periodMillis <= 0L) {
            throw new IllegalArgumentException("Period must be positive");
        }
        this.periodMillis = periodMillis;
        return this;
    }

    @Contract(value="_ -> this")
    public AnimatedButton setPeriodTicks(long periodTicks) {
        return this.setPeriodMillis(Math.max(periodTicks, 1L) * GUIProperties.getMillisPerTick());
    }

    @Contract(value="_ -> this")
    public <T extends Button> AnimatedButton addButton(@NotNull @NotNull Collection<@NotNull T> buttons) {
        this.buttons.addAll(buttons);
        return this;
    }

    @Contract(value="_ -> this")
    public AnimatedButton addButton(Button ... button) {
        return this.addButton(Arrays.asList(button));
    }

    public List<Button> getButtons() {
        return this.buttons;
    }

    private Animation<Button> getAnimation(UUID uuid) {
        return this.animationMap.computeIfAbsent(uuid, key -> new Animation<Button>(this.buttons, this.periodMillis));
    }

    @Override
    public DisplayButton display(@NotNull UUID uuid) {
        return this.getAnimation(uuid).getCurrentFrame().display(uuid);
    }

    @Override
    public void init() {
        if (this.buttons.isEmpty()) {
            throw new IllegalArgumentException("There is no child button for this animated button");
        }
        this.buttons.forEach(Initializable::init);
    }

    @Override
    public void stop() {
        this.animationMap.clear();
        this.buttons.forEach(Initializable::stop);
    }
}

