/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.expansion.extra.expansion;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import me.hsgamer.bettergui.lib.core.expansion.extra.expansion.GetClassLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DataFolder
extends GetClassLoader {
    public static String normalizeJarPath(String path) {
        return path.replace('\\', '/');
    }

    @NotNull
    default public File getDataFolder() {
        return new File(this.getExpansionClassLoader().getManager().getExpansionsDir(), this.getExpansionClassLoader().getDescription().getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    default public InputStream getResource(@NotNull String path) {
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Path cannot be null or empty");
        }
        String newPath = DataFolder.normalizeJarPath(path);
        try (JarFile jar = new JarFile(this.getExpansionClassLoader().getFile());){
            JarEntry jarConfig = jar.getJarEntry(newPath);
            if (jarConfig == null) return null;
            InputStream inputStream = jar.getInputStream(jarConfig);
            return inputStream;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot load path " + newPath, e);
        }
    }

    default public void saveResource(@NotNull String path, boolean replace) {
        try (InputStream inputStream = this.getResource(path);){
            if (inputStream == null) {
                throw new IllegalArgumentException("The embedded resource '" + path + "' cannot be found");
            }
            File out = new File(this.getDataFolder(), DataFolder.normalizeJarPath(path));
            File parent = out.getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                throw new IllegalStateException("Cannot create parent folder");
            }
            if (!out.exists() || replace) {
                Files.copy(inputStream, out.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot load path " + path, e);
        }
    }
}

