/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.expansion.common;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import me.hsgamer.bettergui.lib.core.expansion.common.Expansion;
import me.hsgamer.bettergui.lib.core.expansion.common.ExpansionClassLoader;
import me.hsgamer.bettergui.lib.core.expansion.common.ExpansionDescription;
import me.hsgamer.bettergui.lib.core.expansion.common.ExpansionState;
import me.hsgamer.bettergui.lib.core.expansion.common.exception.ExpansionClassLoaderException;
import me.hsgamer.bettergui.lib.core.expansion.common.exception.InvalidExpansionFileException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpansionManager {
    public static final Function<ExpansionClassLoader, Expansion> DEFAULT_EXPANSION_FACTORY = classLoader -> {
        try {
            Class<?> clazz = Class.forName(classLoader.getDescription().getMainClass(), false, classLoader);
            if (!Expansion.class.isAssignableFrom(clazz)) {
                throw new ClassCastException("The main class does not extend " + Expansion.class.getSimpleName());
            }
            Class<Expansion> newClass = clazz.asSubclass(Expansion.class);
            return newClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Cannot create a new instance of the main class", e);
        }
    };
    protected final Map<String, ExpansionClassLoader> classLoaders = new LinkedHashMap<String, ExpansionClassLoader>();
    @NotNull
    private final File expansionsDir;
    @NotNull
    private final ClassLoader parentClassLoader;
    @NotNull
    private final Function<JarFile, ExpansionDescription> descriptionFactory;
    @NotNull
    private final Set<BiConsumer<ExpansionClassLoader, ExpansionState>> stateListeners = new HashSet<BiConsumer<ExpansionClassLoader, ExpansionState>>();
    @NotNull
    private Function<ExpansionClassLoader, Expansion> expansionFactory = DEFAULT_EXPANSION_FACTORY;
    @NotNull
    private Consumer<Throwable> exceptionHandler = Throwable::printStackTrace;
    @NotNull
    private UnaryOperator<Map<String, ExpansionClassLoader>> sortAndFilterFunction = UnaryOperator.identity();

    public ExpansionManager(@NotNull File expansionsDir, @NotNull Function<JarFile, ExpansionDescription> descriptionFactory, @NotNull ClassLoader parentClassLoader) {
        this.expansionsDir = expansionsDir;
        this.descriptionFactory = descriptionFactory;
        this.parentClassLoader = parentClassLoader;
        if (!expansionsDir.exists()) {
            if (!expansionsDir.mkdirs()) {
                throw new IllegalStateException("Cannot create expansion directory");
            }
        } else if (!expansionsDir.isDirectory()) {
            throw new IllegalStateException("Expansion directory is not a directory");
        }
    }

    public ExpansionManager(@NotNull File expansionsDir, @NotNull Function<JarFile, ExpansionDescription> descriptionFactory) {
        this(expansionsDir, descriptionFactory, ExpansionManager.class.getClassLoader());
    }

    @NotNull
    public final File getExpansionsDir() {
        return this.expansionsDir;
    }

    @NotNull
    public ClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    public void addStateListener(@NotNull BiConsumer<ExpansionClassLoader, ExpansionState> listener) {
        this.stateListeners.add(listener);
    }

    public void removeStateListener(@NotNull BiConsumer<ExpansionClassLoader, ExpansionState> listener) {
        this.stateListeners.remove(listener);
    }

    public Map<String, ExpansionClassLoader> getClassLoaders() {
        return Collections.unmodifiableMap(this.classLoaders);
    }

    public void setExceptionHandler(@NotNull Consumer<Throwable> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setSortAndFilterFunction(@NotNull UnaryOperator<Map<String, ExpansionClassLoader>> sortAndFilterFunction) {
        this.sortAndFilterFunction = sortAndFilterFunction;
    }

    @NotNull
    Function<ExpansionClassLoader, Expansion> getExpansionFactory() {
        return this.expansionFactory;
    }

    public void setExpansionFactory(@NotNull Function<ExpansionClassLoader, Expansion> expansionFactory) {
        this.expansionFactory = expansionFactory;
    }

    public void loadExpansions() {
        HashMap initClassLoaders = new HashMap();
        Arrays.stream(Objects.requireNonNull(this.expansionsDir.listFiles())).filter(file -> file.isFile() && file.getName().toLowerCase(Locale.ROOT).endsWith(".jar")).forEach(file -> {
            ExpansionClassLoader loader;
            ExpansionDescription description;
            try (JarFile jar = new JarFile((File)file);){
                description = this.descriptionFactory.apply(jar);
                if (initClassLoaders.containsKey(description.getName())) {
                    return;
                }
                loader = new ExpansionClassLoader(this, (File)file, description, this.parentClassLoader);
            }
            catch (Exception e) {
                this.exceptionHandler.accept(new InvalidExpansionFileException("Cannot load expansion file " + file.getName(), (File)file, e));
                return;
            }
            initClassLoaders.put(description.getName(), loader);
        });
        Map sortedClassLoaders = (Map)this.sortAndFilterFunction.apply(initClassLoaders);
        Map<String, ExpansionClassLoader> remainingClassLoaders = initClassLoaders.entrySet().stream().filter(entry -> !sortedClassLoaders.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        remainingClassLoaders.values().forEach(loader -> loader.setState(ExpansionState.ERROR));
        this.classLoaders.putAll(remainingClassLoaders);
        this.classLoaders.putAll(sortedClassLoaders);
        sortedClassLoaders.forEach((key, loader) -> {
            try {
                loader.initExpansion();
                loader.setState(ExpansionState.LOADING);
                Expansion expansion = loader.getExpansion();
                if (!expansion.onLoad()) {
                    throw new IllegalStateException("onLoad() returned false");
                }
                loader.setState(ExpansionState.LOADED);
            }
            catch (Throwable t) {
                loader.setThrowable(t);
                loader.setState(ExpansionState.ERROR);
            }
        });
    }

    public void enableExpansions() {
        this.classLoaders.forEach((name, loader) -> {
            if (loader.getState() == ExpansionState.LOADED) {
                Expansion expansion = loader.getExpansion();
                try {
                    loader.setState(ExpansionState.ENABLING);
                    expansion.onEnable();
                    loader.setState(ExpansionState.ENABLED);
                }
                catch (Throwable t) {
                    loader.setThrowable(t);
                    loader.setState(ExpansionState.ERROR);
                }
            }
        });
    }

    public void disableExpansions() {
        Map.Entry entry;
        LinkedList<Map.Entry<String, ExpansionClassLoader>> stack = new LinkedList<Map.Entry<String, ExpansionClassLoader>>(this.classLoaders.entrySet());
        while ((entry = (Map.Entry)stack.pollLast()) != null) {
            ExpansionClassLoader loader = (ExpansionClassLoader)entry.getValue();
            if (loader.getState() != ExpansionState.ENABLED) continue;
            try {
                loader.setState(ExpansionState.DISABLING);
                loader.getExpansion().onDisable();
                loader.setState(ExpansionState.DISABLED);
            }
            catch (Throwable t) {
                loader.setThrowable(t);
                loader.setState(ExpansionState.ERROR);
            }
        }
    }

    public void clearExpansions() {
        this.classLoaders.values().forEach(this::closeClassLoaderSafe);
        this.classLoaders.clear();
    }

    public void call(Consumer<Expansion> consumer) {
        this.classLoaders.values().forEach(classLoader -> {
            if (classLoader.getState() == ExpansionState.ENABLED) {
                consumer.accept(classLoader.getExpansion());
            }
        });
    }

    public <T> void call(Class<T> clazz, Consumer<T> consumer) {
        this.call(expansion -> {
            if (clazz.isInstance(expansion)) {
                consumer.accept(clazz.cast(expansion));
            }
        });
    }

    public Optional<ExpansionClassLoader> getExpansionClassLoader(@NotNull String name) {
        return Optional.ofNullable(this.classLoaders.get(name));
    }

    public Optional<Expansion> getExpansion(@NotNull String name) {
        return this.getExpansionClassLoader(name).map(ExpansionClassLoader::getExpansion);
    }

    @NotNull
    public Map<String, Expansion> getEnabledExpansions() {
        return this.classLoaders.entrySet().parallelStream().filter(entry -> ((ExpansionClassLoader)entry.getValue()).getState() == ExpansionState.ENABLED).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ExpansionClassLoader)entry.getValue()).getExpansion()));
    }

    @Nullable
    Class<?> loadClass(@NotNull ExpansionClassLoader classLoader, @NotNull String name, boolean resolve) {
        for (ExpansionClassLoader loader : this.classLoaders.values()) {
            Class<?> clazz;
            if (loader == classLoader || (clazz = loader.loadClass(name, resolve, false)) == null) continue;
            return clazz;
        }
        return null;
    }

    void notifyStateChange(@NotNull ExpansionClassLoader classLoader, @NotNull ExpansionState state) {
        for (BiConsumer<ExpansionClassLoader, ExpansionState> listener : this.stateListeners) {
            listener.accept(classLoader, state);
        }
    }

    private void closeClassLoaderSafe(@NotNull ExpansionClassLoader classLoader) {
        try {
            classLoader.close();
        }
        catch (Throwable e) {
            this.exceptionHandler.accept(new ExpansionClassLoaderException(classLoader, "Failed to close class loader", e));
        }
    }
}

