/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.common;

import java.math.BigDecimal;
import java.net.URL;
import java.util.Base64;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Validate {
    private Validate() {
    }

    public static Optional<BigDecimal> getNumber(@NotNull String input) {
        try {
            return Optional.of(new BigDecimal(input));
        }
        catch (NumberFormatException ex) {
            return Optional.empty();
        }
    }

    public static Optional<URL> getURL(@NotNull String input) {
        try {
            return Optional.of(new URL(input));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static Optional<byte[]> getBase64(@NotNull String input) {
        try {
            return Optional.of(Base64.getDecoder().decode(input));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static Optional<UUID> getUUID(@NotNull String input) {
        try {
            return Optional.of(UUID.fromString(input));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static boolean isClassLoaded(@NotNull String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isMethodLoaded(@NotNull String className, @NotNull String methodName, Class<?> ... params) {
        try {
            Class.forName(className).getDeclaredMethod(methodName, params);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isConstructorLoaded(@NotNull String className, Class<?> ... params) {
        try {
            Class.forName(className).getDeclaredConstructor(params);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isNullOrEmpty(@Nullable Collection<?> list) {
        return list == null || list.isEmpty();
    }

    public static boolean isNullOrEmpty(@Nullable String string) {
        return string == null || string.isEmpty();
    }
}

