/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.bukkit.utils;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;

public final class VersionUtils {
    private static final int MAJOR_VERSION;
    private static final int MINOR_VERSION;
    private static final int PATCH_VERSION;
    private static final boolean IS_CRAFTBUKKIT_MAPPED;
    private static final String CRAFTBUKKIT_PACKAGE_VERSION;

    private VersionUtils() {
    }

    public static int getMajorVersion() {
        return MAJOR_VERSION;
    }

    public static int getMinorVersion() {
        return MINOR_VERSION;
    }

    public static int getPatchVersion() {
        return PATCH_VERSION;
    }

    public static int compare(int majorVersion, int minorVersion, int patchVersion) {
        int compare = Integer.compare(majorVersion, MAJOR_VERSION);
        if (compare == 0) {
            compare = Integer.compare(minorVersion, MINOR_VERSION);
        }
        if (compare == 0) {
            compare = Integer.compare(patchVersion, PATCH_VERSION);
        }
        return compare;
    }

    public static int compare(int majorVersion, int minorVersion) {
        return VersionUtils.compare(majorVersion, minorVersion, VersionUtils.getPatchVersion());
    }

    public static int compare(int majorVersion) {
        return VersionUtils.compare(majorVersion, VersionUtils.getMinorVersion());
    }

    public static boolean isAtLeast(int majorVersion) {
        return VersionUtils.compare(majorVersion) >= 0;
    }

    public static boolean isAtLeast(int majorVersion, int minorVersion) {
        return VersionUtils.compare(majorVersion, minorVersion) >= 0;
    }

    public static boolean isAt(int majorVersion) {
        return VersionUtils.compare(majorVersion) == 0;
    }

    public static boolean isAt(int majorVersion, int minorVersion) {
        return VersionUtils.compare(majorVersion, minorVersion) == 0;
    }

    public static boolean isNewerThan(int majorVersion) {
        return VersionUtils.compare(majorVersion) > 0;
    }

    public static boolean isNewerThan(int majorVersion, int minorVersion) {
        return VersionUtils.compare(majorVersion, minorVersion) > 0;
    }

    public static boolean isLowerThan(int majorVersion) {
        return VersionUtils.compare(majorVersion) < 0;
    }

    public static boolean isLowerThan(int majorVersion, int minorVersion) {
        return VersionUtils.compare(majorVersion, minorVersion) < 0;
    }

    public static boolean isCraftBukkitMapped() {
        return IS_CRAFTBUKKIT_MAPPED;
    }

    public static String getCraftBukkitPackageVersion() {
        return CRAFTBUKKIT_PACKAGE_VERSION;
    }

    static {
        Matcher versionMatcher = Pattern.compile("MC: (\\d+)\\.(\\d+)(\\.(\\d+))?").matcher(Bukkit.getVersion());
        if (versionMatcher.find()) {
            int majorVersion = Integer.parseInt(versionMatcher.group(1));
            int minorVersion = Integer.parseInt(versionMatcher.group(2));
            int patchVersion = Optional.ofNullable(versionMatcher.group(4)).filter(s -> !s.isEmpty()).map(Integer::parseInt).orElse(0);
            if (majorVersion == 1) {
                MAJOR_VERSION = minorVersion;
                MINOR_VERSION = patchVersion;
                PATCH_VERSION = 0;
            } else {
                MAJOR_VERSION = majorVersion;
                MINOR_VERSION = minorVersion;
                PATCH_VERSION = patchVersion;
            }
        } else {
            MAJOR_VERSION = -1;
            MINOR_VERSION = -1;
            PATCH_VERSION = -1;
        }
        Matcher packageMatcher = Pattern.compile("v\\d+_\\d+_R\\d+").matcher(Bukkit.getServer().getClass().getPackage().getName());
        IS_CRAFTBUKKIT_MAPPED = packageMatcher.find();
        CRAFTBUKKIT_PACKAGE_VERSION = IS_CRAFTBUKKIT_MAPPED ? packageMatcher.group() : "";
    }
}

