/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.bukkit.item.modifier;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.hsgamer.bettergui.lib.core.common.CollectionUtils;
import me.hsgamer.bettergui.lib.core.common.StringReplacer;
import me.hsgamer.bettergui.lib.core.minecraft.item.ItemComparator;
import me.hsgamer.bettergui.lib.core.minecraft.item.ItemModifier;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class MaterialModifier
implements ItemComparator<ItemStack>,
ItemModifier<ItemStack> {
    private static final Map<Integer, Material> ID_MATERIAL_MAP = new HashMap<Integer, Material>();
    private List<String> materialList = Collections.emptyList();

    private static Material getMaterial(String materialString) {
        Material material;
        materialString = materialString.replace(" ", "_");
        try {
            material = Material.matchMaterial((String)materialString);
        }
        catch (Exception ignored) {
            material = null;
        }
        if (material == null) {
            try {
                material = ID_MATERIAL_MAP.get(Integer.parseInt(materialString));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return material;
    }

    private static boolean setMaterial(ItemStack itemStack, String materialString) {
        String[] split = materialString.split(":", 2);
        Material material = MaterialModifier.getMaterial(split[0].trim());
        if (material != null) {
            itemStack.setType(material);
            if (split.length > 1) {
                itemStack.setDurability(Short.parseShort(split[1].trim()));
            }
            return true;
        }
        return false;
    }

    private static boolean compareMaterial(ItemStack itemStack, String materialString) {
        String[] split = materialString.split(":", 2);
        Material material = MaterialModifier.getMaterial(split[0].trim());
        if (itemStack.getType() == material) {
            if (split.length > 1) {
                return itemStack.getDurability() == Short.parseShort(split[1].trim());
            }
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public ItemStack modify(@NotNull ItemStack original, UUID uuid, @NotNull StringReplacer stringReplacer) {
        for (String materialString : this.materialList) {
            if (MaterialModifier.setMaterial(original, stringReplacer.replaceOrOriginal(materialString, uuid))) break;
        }
        return original;
    }

    @Override
    public Object toObject() {
        return this.materialList;
    }

    @Override
    public void loadFromObject(Object object) {
        this.materialList = CollectionUtils.createStringListFromObject(object, true);
    }

    @Override
    public boolean loadFromItem(ItemStack item) {
        this.materialList = Collections.singletonList(item.getType().name());
        return true;
    }

    @Override
    public boolean compare(@NotNull ItemStack item, UUID uuid, @NotNull StringReplacer stringReplacer) {
        if (this.materialList.isEmpty()) {
            return true;
        }
        return this.materialList.parallelStream().map(s -> stringReplacer.replaceOrOriginal((String)s, uuid)).anyMatch(s -> MaterialModifier.compareMaterial(item, s));
    }

    @Contract(value="_ -> this")
    public MaterialModifier setMaterial(Material material) {
        this.materialList = Collections.singletonList(material.name());
        return this;
    }

    @Contract(value="_ -> this")
    public MaterialModifier setMaterial(String ... material) {
        this.materialList = Arrays.asList(material);
        return this;
    }

    static {
        for (Material material : Material.values()) {
            try {
                ID_MATERIAL_MAP.put(material.getId(), material);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

