/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.bukkit.item.modifier;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.hsgamer.bettergui.lib.core.bukkit.item.modifier.ItemMetaComparator;
import me.hsgamer.bettergui.lib.core.bukkit.item.modifier.ItemMetaModifier;
import me.hsgamer.bettergui.lib.core.common.CollectionUtils;
import me.hsgamer.bettergui.lib.core.common.StringReplacer;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemFlagModifier
implements ItemMetaModifier,
ItemMetaComparator {
    private List<String> flagList = Collections.emptyList();

    private Set<ItemFlag> getParsed(UUID uuid, StringReplacer stringReplacer) {
        HashSet<ItemFlag> flags = new HashSet<ItemFlag>();
        this.flagList.forEach(string -> {
            if ((string = stringReplacer.replaceOrOriginal((String)string, uuid).trim()).equalsIgnoreCase("all")) {
                Collections.addAll(flags, ItemFlag.values());
                return;
            }
            try {
                flags.add(ItemFlag.valueOf((String)string.toUpperCase().replace(" ", "_")));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
        return flags;
    }

    @Override
    @NotNull
    public ItemMeta modifyMeta(@NotNull ItemMeta meta, @Nullable UUID uuid, @NotNull StringReplacer stringReplacer) {
        for (ItemFlag flag : this.getParsed(uuid, stringReplacer)) {
            meta.addItemFlags(new ItemFlag[]{flag});
        }
        return meta;
    }

    @Override
    public boolean loadFromItemMeta(ItemMeta meta) {
        this.flagList = meta.getItemFlags().stream().map(Enum::name).collect(Collectors.toList());
        return true;
    }

    @Override
    public boolean compare(@NotNull ItemMeta meta, @Nullable UUID uuid, @NotNull StringReplacer stringReplacer) {
        Set<ItemFlag> list1 = this.getParsed(uuid, stringReplacer);
        Set list2 = meta.getItemFlags();
        return list1.size() == list2.size() && list1.containsAll(list2);
    }

    @Override
    public Object toObject() {
        return this.flagList;
    }

    @Override
    public void loadFromObject(Object object) {
        this.flagList = CollectionUtils.createStringListFromObject(object, true);
    }

    public ItemFlagModifier setFlag(ItemFlag ... flags) {
        this.flagList = Arrays.stream(flags).map(Enum::name).collect(Collectors.toList());
        return this;
    }
}

