/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.bukkit.item.modifier;

import java.util.UUID;
import me.hsgamer.bettergui.lib.core.common.StringReplacer;
import me.hsgamer.bettergui.lib.core.common.Validate;
import me.hsgamer.bettergui.lib.core.minecraft.item.ItemComparator;
import me.hsgamer.bettergui.lib.core.minecraft.item.ItemModifier;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class DurabilityModifier
implements ItemComparator<ItemStack>,
ItemModifier<ItemStack> {
    private String durability = "1";

    @Override
    @NotNull
    public ItemStack modify(@NotNull ItemStack original, UUID uuid, @NotNull StringReplacer stringReplacer) {
        Validate.getNumber(stringReplacer.replaceOrOriginal(this.durability, uuid)).ifPresent(bigDecimal -> original.setDurability(bigDecimal.shortValue()));
        return original;
    }

    @Override
    public Object toObject() {
        return this.durability;
    }

    @Override
    public void loadFromObject(Object object) {
        this.durability = String.valueOf(object);
    }

    @Override
    public boolean loadFromItem(ItemStack item) {
        this.durability = String.valueOf(item.getDurability());
        return true;
    }

    @Override
    public boolean compare(@NotNull ItemStack item, UUID uuid, @NotNull StringReplacer stringReplacer) {
        return Validate.getNumber(stringReplacer.replaceOrOriginal(this.durability, uuid)).map(bigDecimal -> bigDecimal.shortValue() == item.getDurability()).orElse(false);
    }

    @Contract(value="_ -> this")
    public DurabilityModifier setDurability(String durability) {
        this.durability = durability;
        return this;
    }

    @Contract(value="_ -> this")
    public DurabilityModifier setDurability(short durability) {
        this.durability = String.valueOf(durability);
        return this;
    }
}

