/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.bukkit.item.modifier;

import java.util.UUID;
import me.hsgamer.bettergui.lib.core.common.StringReplacer;
import me.hsgamer.bettergui.lib.core.common.Validate;
import me.hsgamer.bettergui.lib.core.minecraft.item.ItemComparator;
import me.hsgamer.bettergui.lib.core.minecraft.item.ItemModifier;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class AmountModifier
implements ItemComparator<ItemStack>,
ItemModifier<ItemStack> {
    private String amount = "1";

    @Override
    @NotNull
    public ItemStack modify(@NotNull ItemStack original, UUID uuid, @NotNull StringReplacer stringReplacer) {
        Validate.getNumber(stringReplacer.replaceOrOriginal(this.amount, uuid)).ifPresent(bigDecimal -> original.setAmount(bigDecimal.intValue()));
        return original;
    }

    @Override
    public Object toObject() {
        return this.amount;
    }

    @Override
    public void loadFromObject(Object object) {
        this.amount = String.valueOf(object);
    }

    @Override
    public boolean loadFromItem(ItemStack item) {
        this.amount = String.valueOf(item.getAmount());
        return true;
    }

    @Override
    public boolean compare(@NotNull ItemStack item, UUID uuid, @NotNull StringReplacer stringReplacer) {
        return Validate.getNumber(stringReplacer.replaceOrOriginal(this.amount, uuid)).map(bigDecimal -> bigDecimal.intValue() >= item.getAmount()).orElse(false);
    }

    @Contract(value="_ -> this")
    public AmountModifier setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    @Contract(value="_ -> this")
    public AmountModifier setAmount(int amount) {
        this.amount = String.valueOf(amount);
        return this;
    }
}

