/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.bukkit.gui;

import java.util.function.Consumer;
import me.hsgamer.bettergui.lib.core.bukkit.gui.BukkitGUIDisplay;
import me.hsgamer.bettergui.lib.core.bukkit.gui.BukkitGUIHolder;
import me.hsgamer.bettergui.lib.core.bukkit.gui.event.BukkitClickEvent;
import me.hsgamer.bettergui.lib.core.bukkit.gui.event.BukkitCloseEvent;
import me.hsgamer.bettergui.lib.core.bukkit.gui.event.BukkitDragEvent;
import me.hsgamer.bettergui.lib.core.bukkit.gui.event.BukkitOpenEvent;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;

public class BukkitGUIListener
implements Listener {
    private final Plugin plugin;

    private BukkitGUIListener(Plugin plugin, EventPriority clickPriority, EventPriority dragPriority, EventPriority openPriority, EventPriority closePriority) {
        this.plugin = plugin;
        this.registerEvent(InventoryClickEvent.class, clickPriority, this::onInventoryClick);
        this.registerEvent(InventoryDragEvent.class, dragPriority, this::onInventoryDrag);
        this.registerEvent(InventoryOpenEvent.class, openPriority, this::onInventoryOpen);
        this.registerEvent(InventoryCloseEvent.class, closePriority, this::onInventoryClose);
        this.registerEvent(PluginDisableEvent.class, EventPriority.MONITOR, this::onPluginDisable);
    }

    public static BukkitGUIListener init(Plugin plugin, EventPriority clickPriority, EventPriority dragPriority, EventPriority openPriority, EventPriority closePriority) {
        return new BukkitGUIListener(plugin, clickPriority, dragPriority, openPriority, closePriority);
    }

    public static BukkitGUIListener init(Plugin plugin) {
        return BukkitGUIListener.init(plugin, EventPriority.LOW, EventPriority.LOW, EventPriority.NORMAL, EventPriority.NORMAL);
    }

    private static void handleIfDisplay(InventoryEvent event, Consumer<BukkitGUIDisplay> consumer) {
        InventoryHolder holder = event.getInventory().getHolder();
        if (holder instanceof BukkitGUIDisplay) {
            consumer.accept((BukkitGUIDisplay)holder);
        }
    }

    private <T extends Event> void registerEvent(Class<T> eventClass, EventPriority priority, Consumer<T> consumer) {
        Bukkit.getPluginManager().registerEvent(eventClass, (Listener)this, priority, (listener, event) -> {
            if (eventClass.isInstance(event)) {
                consumer.accept((Event)eventClass.cast(event));
            }
        }, this.plugin);
    }

    private void onInventoryClick(InventoryClickEvent event) {
        BukkitGUIListener.handleIfDisplay((InventoryEvent)event, display -> {
            boolean wasCancelled = event.isCancelled();
            event.setCancelled(true);
            ((BukkitGUIHolder)display.getHolder()).handleEvent(new BukkitClickEvent(event));
            if (!wasCancelled && !event.isCancelled()) {
                event.setCancelled(false);
            }
        });
    }

    private void onInventoryOpen(InventoryOpenEvent event) {
        BukkitGUIListener.handleIfDisplay((InventoryEvent)event, display -> ((BukkitGUIHolder)display.getHolder()).handleEvent(new BukkitOpenEvent(event)));
    }

    private void onInventoryClose(InventoryCloseEvent event) {
        BukkitGUIListener.handleIfDisplay((InventoryEvent)event, display -> ((BukkitGUIHolder)display.getHolder()).handleEvent(new BukkitCloseEvent(event)));
    }

    private void onInventoryDrag(InventoryDragEvent event) {
        BukkitGUIListener.handleIfDisplay((InventoryEvent)event, display -> ((BukkitGUIHolder)display.getHolder()).handleEvent(new BukkitDragEvent(event)));
    }

    private void onPluginDisable(PluginDisableEvent event) {
        if (event.getPlugin().equals(this.plugin)) {
            HandlerList.unregisterAll((Listener)this);
        }
    }
}

