/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.lib.core.bukkit.clicktype;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import me.hsgamer.bettergui.lib.core.bukkit.clicktype.BukkitClickType;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;

public final class ClickTypeUtils {
    private static final Map<String, BukkitClickType> clickTypeMap = new HashMap<String, BukkitClickType>();

    private ClickTypeUtils() {
    }

    @NotNull
    public static BukkitClickType getClickTypeFromEvent(@NotNull InventoryClickEvent event, boolean useSlot) {
        ClickType clickType = event.getClick();
        if (!useSlot || !clickType.equals((Object)ClickType.NUMBER_KEY)) {
            return clickTypeMap.get(clickType.name());
        }
        return clickTypeMap.get(ClickType.NUMBER_KEY.name() + "_" + event.getHotbarButton());
    }

    @NotNull
    public static Map<String, BukkitClickType> getClickTypeMap() {
        return Collections.unmodifiableMap(clickTypeMap);
    }

    static {
        ArrayList<BukkitClickType> clickTypeList = new ArrayList<BukkitClickType>();
        for (ClickType clickType2 : ClickType.values()) {
            clickTypeList.add(new BukkitClickType(clickType2));
        }
        IntStream.range(0, 9).mapToObj(i -> new BukkitClickType(ClickType.NUMBER_KEY, i)).forEach(clickTypeList::add);
        clickTypeList.forEach(clickType -> clickTypeMap.put(clickType.getName(), (BukkitClickType)clickType));
    }
}

