/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.hsgamer.bettergui.BetterGUI;
import me.hsgamer.bettergui.Permissions;
import me.hsgamer.bettergui.config.MessageConfig;
import me.hsgamer.bettergui.lib.core.bukkit.utils.MessageUtils;
import me.hsgamer.bettergui.manager.MenuManager;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

public final class OpenCommand
extends BukkitCommand {
    private final BetterGUI plugin;

    public OpenCommand(BetterGUI plugin) {
        super("openmenu", "Open the specific menu", "/openmenu <menu_name> [player] [args...]", Collections.singletonList("om"));
        this.setPermission(Permissions.OPEN_MENU.getName());
        this.plugin = plugin;
    }

    public boolean execute(CommandSender commandSender, String s, String[] strings) {
        Player player;
        if (!this.testPermission(commandSender)) {
            return false;
        }
        if (strings.length == 0) {
            MessageUtils.sendMessage(commandSender, this.plugin.get(MessageConfig.class).getMenuRequired());
            return false;
        }
        if (!this.plugin.get(MenuManager.class).contains(strings[0])) {
            MessageUtils.sendMessage(commandSender, this.plugin.get(MessageConfig.class).getMenuNotFound());
            return false;
        }
        String menuName = strings[0];
        String[] args = new String[]{};
        if (strings.length > 1) {
            player = Bukkit.getPlayer((String)strings[1]);
            if (player == null || !player.isOnline()) {
                MessageUtils.sendMessage(commandSender, this.plugin.get(MessageConfig.class).getPlayerNotFound());
                return false;
            }
            args = Arrays.copyOfRange(strings, 2, strings.length);
        } else if (commandSender instanceof Player) {
            player = (Player)commandSender;
        } else {
            MessageUtils.sendMessage(commandSender, this.plugin.get(MessageConfig.class).getPlayerOnly());
            return false;
        }
        this.plugin.get(MenuManager.class).openMenu(menuName, player, args, player.hasPermission(Permissions.OPEN_MENU_BYPASS));
        return true;
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
        Player player;
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1) {
            list.addAll(this.plugin.get(MenuManager.class).getMenuNames());
        } else if (args.length == 2) {
            list.addAll(Bukkit.getOnlinePlayers().stream().map(HumanEntity::getName).collect(Collectors.toList()));
        } else if (args.length > 2 && this.plugin.get(MenuManager.class).contains(args[0]) && (player = Bukkit.getPlayer((String)args[1])) != null && player.isOnline()) {
            list.addAll(this.plugin.get(MenuManager.class).tabCompleteMenu(args[0], player, Arrays.copyOfRange(args, 2, args.length)));
        }
        return list;
    }
}

