/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.hsgamer.bettergui.BetterGUI;
import me.hsgamer.bettergui.Permissions;
import me.hsgamer.bettergui.api.menu.Menu;
import me.hsgamer.bettergui.config.MessageConfig;
import me.hsgamer.bettergui.lib.core.bukkit.utils.MessageUtils;
import me.hsgamer.bettergui.lib.core.variable.VariableManager;
import me.hsgamer.bettergui.manager.MenuManager;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;

public class GetVariablesCommand
extends BukkitCommand {
    private final BetterGUI plugin;

    public GetVariablesCommand(BetterGUI plugin) {
        super("getvariables", "Get the registered variables", "/getvariables [menu_name]", Arrays.asList("variables", "placeholders", "getplaceholders"));
        this.plugin = plugin;
        this.setPermission(Permissions.VARIABLE.getName());
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return false;
        }
        ArrayList<String> variables = new ArrayList<String>();
        if (args.length > 0) {
            Menu menu = this.plugin.get(MenuManager.class).getMenu(args[0]);
            if (menu == null) {
                MessageUtils.sendMessage(sender, this.plugin.get(MessageConfig.class).getMenuNotFound());
                return false;
            }
            variables.addAll(menu.getVariableManager().getVariables().keySet());
        } else {
            variables.addAll(VariableManager.GLOBAL.getVariables().keySet());
            for (String menuName : this.plugin.get(MenuManager.class).getMenuNames()) {
                Menu menu = this.plugin.get(MenuManager.class).getMenu(menuName);
                if (menu == null) continue;
                menu.getVariableManager().getVariables().keySet().forEach(variable -> variables.add("menu_" + menuName + "_" + variable));
            }
        }
        MessageUtils.sendMessage(sender, "&bRegistered Variables:");
        variables.forEach(variable -> MessageUtils.sendMessage(sender, "&f- &e" + variable));
        return true;
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1) {
            list.addAll(this.plugin.get(MenuManager.class).getMenuNames());
        }
        return list;
    }
}

