/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.builder;

import java.util.List;
import java.util.stream.Collectors;
import me.hsgamer.bettergui.BetterGUI;
import me.hsgamer.bettergui.action.type.BackAction;
import me.hsgamer.bettergui.action.type.CloseMenuAction;
import me.hsgamer.bettergui.action.type.OpenMenuAction;
import me.hsgamer.bettergui.action.type.SoundAction;
import me.hsgamer.bettergui.action.type.UpdateMenuAction;
import me.hsgamer.bettergui.api.menu.Menu;
import me.hsgamer.bettergui.api.menu.MenuElement;
import me.hsgamer.bettergui.lib.core.action.builder.ActionInput;
import me.hsgamer.bettergui.lib.core.action.common.Action;
import me.hsgamer.bettergui.lib.core.bukkit.action.PlayerAction;
import me.hsgamer.bettergui.lib.core.bukkit.action.builder.BukkitActionBuilder;
import me.hsgamer.bettergui.lib.core.common.CollectionUtils;
import org.bukkit.plugin.Plugin;

public final class ActionBuilder
extends me.hsgamer.bettergui.lib.core.action.builder.ActionBuilder<Input> {
    public static final ActionBuilder INSTANCE = new ActionBuilder();

    private ActionBuilder() {
        BukkitActionBuilder.register(this, (Plugin)BetterGUI.getInstance());
        this.register(OpenMenuAction::new, "open-menu", "open", "menu", "open-menu");
        this.register(BackAction::new, "back-menu", "backmenu");
        this.register((I input) -> new CloseMenuAction(input.getMenu()), "close-menu", "closemenu");
        this.register((I input) -> new UpdateMenuAction(input.getMenu()), "update-menu", "updatemenu");
        this.register((I input) -> new SoundAction(input.getValue()), "sound", "raw-sound");
    }

    public List<Action> build(Menu menu, Object object) {
        List inputs = CollectionUtils.createStringListFromObject(object, true).stream().map(input -> Input.create(menu, input)).collect(Collectors.toList());
        return this.build(inputs, (I input) -> new PlayerAction((Plugin)BetterGUI.getInstance(), input.getOriginalValue()));
    }

    public static interface Input
    extends ActionInput,
    MenuElement {
        public static Input create(final Menu menu, final String input) {
            final ActionInput actionInput = ActionInput.create(input);
            return new Input(){

                @Override
                public String getType() {
                    return actionInput.getType();
                }

                @Override
                public String getOption() {
                    return actionInput.getOption();
                }

                @Override
                public String getValue() {
                    return actionInput.getValue();
                }

                @Override
                public Menu getMenu() {
                    return menu;
                }

                @Override
                public String getOriginalValue() {
                    return input;
                }
            };
        }

        public static Input create(MenuElement menuElement, String input) {
            return Input.create(menuElement.getMenu(), input);
        }

        public String getOriginalValue();
    }
}

