/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.bettergui.argument.type;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.hsgamer.bettergui.argument.type.BaseActionArgumentProcessor;
import me.hsgamer.bettergui.builder.ArgumentProcessorBuilder;
import me.hsgamer.bettergui.lib.core.common.Pair;
import me.hsgamer.bettergui.lib.core.task.BatchRunnable;
import me.hsgamer.bettergui.lib.core.task.element.TaskProcess;
import me.hsgamer.bettergui.util.SchedulerUtil;

public abstract class SingleArgumentProcessor<T>
extends BaseActionArgumentProcessor {
    private final Map<UUID, T> map = new HashMap<UUID, T>();
    private final Map<UUID, String> rawMap = new HashMap<UUID, String>();

    public SingleArgumentProcessor(ArgumentProcessorBuilder.Input input) {
        super(input);
    }

    protected abstract Optional<T> getObject(String var1);

    protected abstract Stream<T> getObjectStream();

    protected abstract String getArgumentValue(T var1);

    protected abstract String getValue(String var1, UUID var2, T var3);

    protected Optional<T> getObject(UUID uuid) {
        return Optional.ofNullable(this.map.get(uuid));
    }

    @Override
    public Optional<String[]> process(UUID uuid, String[] args) {
        if (args.length == 0) {
            BatchRunnable batchRunnable = new BatchRunnable();
            batchRunnable.getTaskPool(99).addLast(process -> this.onRequiredActionApplier.accept(uuid, (TaskProcess)process));
            SchedulerUtil.async().run(batchRunnable);
            return Optional.empty();
        }
        String raw = args[0];
        this.rawMap.put(uuid, raw);
        Optional<T> object = this.getObject(raw);
        if (!object.isPresent()) {
            BatchRunnable batchRunnable = new BatchRunnable();
            batchRunnable.getTaskPool(99).addLast(process -> this.onInvalidActionApplier.accept(uuid, (TaskProcess)process));
            SchedulerUtil.async().run(batchRunnable);
            return Optional.empty();
        }
        this.map.put(uuid, object.get());
        return Optional.of(Arrays.copyOfRange(args, 1, args.length));
    }

    @Override
    public String getValue(String query, UUID uuid) {
        if (query.equalsIgnoreCase("raw")) {
            return this.rawMap.getOrDefault(uuid, "");
        }
        Optional<T> object = this.getObject(uuid);
        if (!object.isPresent()) {
            return "";
        }
        T obj = object.get();
        if (query.isEmpty()) {
            return this.getArgumentValue(obj);
        }
        return this.getValue(query, uuid, obj);
    }

    @Override
    public Pair<Optional<List<String>>, String[]> tabComplete(UUID uuid, String[] args) {
        Optional<Object> optionalList;
        if (args.length == 0) {
            return Pair.of(Optional.empty(), args);
        }
        if (args.length == 1) {
            String query = args[0];
            List list = this.getObjectStream().map(this::getArgumentValue).filter(s -> s.toLowerCase(Locale.ROOT).startsWith(query.toLowerCase(Locale.ROOT))).collect(Collectors.toList());
            optionalList = Optional.of(list);
        } else {
            optionalList = Optional.empty();
        }
        return Pair.of(optionalList, Arrays.copyOfRange(args, 1, args.length));
    }
}

